/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import com.webauthn4j.data.AuthenticatorTransport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.WebAuthnCredentialModel;
import org.keycloak.theme.DateTimeFormatterUtil;
import org.keycloak.utils.StringUtil;

public class WebAuthnAuthenticatorsBean {
    private final List<WebAuthnAuthenticatorBean> authenticators;

    public WebAuthnAuthenticatorsBean(KeycloakSession session, RealmModel realm, UserModel user, String credentialType) {
        this.authenticators = user.credentialManager().getStoredCredentialsByTypeStream(credentialType).map(WebAuthnCredentialModel::createFromCredentialModel).map(webAuthnCredential -> {
            String credentialId = Base64Url.encodeBase64ToBase64Url((String)webAuthnCredential.getWebAuthnCredentialData().getCredentialId());
            String label = webAuthnCredential.getUserLabel() == null || webAuthnCredential.getUserLabel().isEmpty() ? "label missing" : webAuthnCredential.getUserLabel();
            String createdAt = DateTimeFormatterUtil.getDateTimeFromMillis((long)webAuthnCredential.getCreatedDate(), session.getContext().resolveLocale(user));
            Set transports = webAuthnCredential.getWebAuthnCredentialData().getTransports();
            return new WebAuthnAuthenticatorBean(credentialId, label, createdAt, transports);
        }).collect(Collectors.toList());
    }

    public List<WebAuthnAuthenticatorBean> getAuthenticators() {
        return this.authenticators;
    }

    public static class WebAuthnAuthenticatorBean {
        public static final String DEFAULT_ICON = "kcWebAuthnDefaultIcon";
        public static final String UNKNOWN_AUTH_ICON = "kcWebAuthnUnknownIcon";
        private final String credentialId;
        private final String label;
        private final String createdAt;
        private final TransportsBean transports;

        public WebAuthnAuthenticatorBean(String credentialId, String label, String createdAt, Set<String> transports) {
            this.credentialId = credentialId;
            this.label = label;
            this.createdAt = createdAt;
            this.transports = TransportsBean.convertFromSet(transports);
        }

        public String getCredentialId() {
            return this.credentialId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public TransportsBean getTransports() {
            return this.transports;
        }

        public static class TransportsBean {
            private final Set<String> displayNameProperties;
            private final String iconClass;

            public TransportsBean(Set<String> displayNameProperties, String iconClass) {
                this.displayNameProperties = displayNameProperties;
                this.iconClass = iconClass;
            }

            public TransportsBean(String displayNameProperty, String iconClass) {
                this(Collections.singleton(displayNameProperty), iconClass);
            }

            public TransportsBean(Transport transport) {
                this(transport.getDisplayNameProperty(), transport.getIconClass());
            }

            public Set<String> getDisplayNameProperties() {
                return this.displayNameProperties;
            }

            public String getIconClass() {
                return this.iconClass;
            }

            public static TransportsBean convertFromSet(Set<String> transports) {
                if (CollectionUtil.isEmpty(transports)) {
                    return new TransportsBean(Transport.UNKNOWN);
                }
                Set trans = transports.stream().filter(Objects::nonNull).map(Transport::getByMapperName).collect(Collectors.toSet());
                if (trans.size() <= 1) {
                    Transport transport = trans.stream().findFirst().orElse(Transport.UNKNOWN);
                    return new TransportsBean(transport);
                }
                Set<String> displayNameProperties = trans.stream().map(Transport::getDisplayNameProperty).filter(StringUtil::isNotBlank).collect(Collectors.toSet());
                return new TransportsBean(displayNameProperties, WebAuthnAuthenticatorBean.DEFAULT_ICON);
            }

            protected static enum Transport {
                USB("usb", AuthenticatorTransport.USB.getValue(), "kcWebAuthnUSB"),
                NFC("nfc", AuthenticatorTransport.NFC.getValue(), "kcWebAuthnNFC"),
                BLE("bluetooth", AuthenticatorTransport.BLE.getValue(), "kcWebAuthnBLE"),
                INTERNAL("internal", AuthenticatorTransport.INTERNAL.getValue(), "kcWebAuthnInternal"),
                UNKNOWN("", "", "kcWebAuthnUnknownIcon");

                private final String displayNameProperty;
                private final String mapperName;
                private final String iconClass;

                private Transport(String displayNameProperty, String mapperName, String iconClass) {
                    this.displayNameProperty = displayNameProperty;
                    this.mapperName = mapperName;
                    this.iconClass = iconClass;
                }

                public String getDisplayNameProperty() {
                    return this.displayNameProperty;
                }

                public String getMapperName() {
                    return this.mapperName;
                }

                public String getIconClass() {
                    return this.iconClass;
                }

                public static Transport getByDisplayNameProperty(String property) {
                    return Arrays.stream(Transport.values()).filter(f -> f.getDisplayNameProperty().equals(property)).findFirst().orElse(UNKNOWN);
                }

                public static Transport getByMapperName(String mapperName) {
                    if (StringUtil.isBlank((String)mapperName)) {
                        return UNKNOWN;
                    }
                    return Arrays.stream(Transport.values()).filter(f -> StringUtil.isNotBlank((String)f.getMapperName())).filter(f -> f.getMapperName().equals(mapperName)).findFirst().orElse(UNKNOWN);
                }
            }
        }
    }
}

