/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertyAccessorSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSyntheticPropertyWithoutJavaOriginChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPropertyAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;)V", "checkers.jvm"})
public final class FirSyntheticPropertyWithoutJavaOriginChecker
extends FirExpressionChecker<FirPropertyAccessExpression> {
    @NotNull
    public static final FirSyntheticPropertyWithoutJavaOriginChecker INSTANCE = new FirSyntheticPropertyWithoutJavaOriginChecker();

    private FirSyntheticPropertyWithoutJavaOriginChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirPropertyAccessExpression expression2) {
        FirNamedFunctionSymbol firNamedFunctionSymbol;
        FirVariableAssignment containingAssignment;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DontCreateSyntheticPropertiesWithoutBaseJavaGetter)) {
            return;
        }
        Object object = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
        FirSimpleSyntheticPropertySymbol firSimpleSyntheticPropertySymbol = object instanceof FirSimpleSyntheticPropertySymbol ? (FirSimpleSyntheticPropertySymbol)object : null;
        if (firSimpleSyntheticPropertySymbol == null) {
            return;
        }
        FirSimpleSyntheticPropertySymbol syntheticProperty = firSimpleSyntheticPropertySymbol;
        object = CollectionsKt.getOrNull(context2.getCallsOrAssignments(), context2.getCallsOrAssignments().size() - 2);
        FirVariableAssignment firVariableAssignment = containingAssignment = object instanceof FirVariableAssignment ? (FirVariableAssignment)object : null;
        boolean isAssignment = (firVariableAssignment != null ? firVariableAssignment.getLValue() : null) == expression2;
        boolean bl = isAssignment;
        if (!bl) {
            FirSyntheticPropertyAccessorSymbol firSyntheticPropertyAccessorSymbol = syntheticProperty.getGetterSymbol();
            firNamedFunctionSymbol = firSyntheticPropertyAccessorSymbol != null ? firSyntheticPropertyAccessorSymbol.getDelegateFunctionSymbol() : null;
        } else if (bl) {
            FirSyntheticPropertyAccessorSymbol firSyntheticPropertyAccessorSymbol = syntheticProperty.getSetterSymbol();
            firNamedFunctionSymbol = firSyntheticPropertyAccessorSymbol != null ? firSyntheticPropertyAccessorSymbol.getDelegateFunctionSymbol() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol originalFunction = firNamedFunctionSymbol;
        if (SyntheticsKt.getNoJavaOrigin(syntheticProperty)) {
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ForbidSyntheticPropertiesWithoutBaseJavaGetter)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getFUNCTION_CALL_EXPECTED(), (Object)originalFunction.getName().asString(), (Object)false, null, 32, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getSYNTHETIC_PROPERTY_WITHOUT_JAVA_ORIGIN(), (Object)originalFunction, (Object)originalFunction.getName(), null, 32, null);
            }
        }
    }
}

