/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class TristateCheckBox
extends JCheckBox
implements ActionListener {
    public static final int STATE_UNSELECTED = 0;
    public static final int STATE_SELECTED = 1;
    public static final int STATE_MIXED = 2;

    public TristateCheckBox(String text, Icon icon) {
        super(text, icon);
    }

    public TristateCheckBox(String text) {
        this(text, null);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    @Override
    protected void init(String text, Icon icon) {
        this.model = this.createButtonModel();
        this.setModel(this.model);
        this.addActionListener(this);
        super.init(text, icon);
    }

    protected ButtonModel createButtonModel() {
        return new TristateButtonModel();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.isMixed()) {
            this.adjustMixedIcon();
        } else {
            this.restoreMixedIcon();
        }
    }

    protected void adjustMixedIcon() {
        this.setIcon(UIManager.getIcon("TristateCheckBox.icon"));
    }

    protected void restoreMixedIcon() {
        this.setIcon(null);
    }

    public boolean isMixed() {
        return this.getState() == 2;
    }

    public void setMixed(boolean b) {
        if (b) {
            this.setState(2);
        } else {
            this.setState(0);
        }
    }

    public int getState() {
        if (this.model instanceof TristateButtonModel) {
            return ((TristateButtonModel)this.model).getState();
        }
        throw new IllegalStateException("TristateButtonModel is required for TristateCheckBox");
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(1);
        } else {
            this.setState(0);
        }
    }

    public void setState(int state) {
        if (this.model instanceof TristateButtonModel) {
            int old = ((TristateButtonModel)this.model).getState();
            if (old != state) {
                ((TristateButtonModel)this.model).setState(state);
            }
        } else {
            throw new IllegalStateException("TristateButtonModel is required for TristateCheckBox");
        }
        this.stateUpdated(state);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stateUpdated(this.getState());
    }

    protected void stateUpdated(int state) {
        if (state == 2) {
            String name;
            this.adjustMixedIcon();
            Object cp = UIDefaultsLookup.get("TristateCheckBox.setMixed.clientProperty");
            if (cp != null) {
                this.putClientProperty(((Object[])cp)[0], ((Object[])cp)[1]);
            }
            if ((name = UIDefaultsLookup.getString("TristateCheckBox.setMixed.componentName")) != null) {
                this.setName(name);
            }
        } else {
            String name;
            this.restoreMixedIcon();
            Object cp = UIDefaultsLookup.get("TristateCheckBox.clearMixed.clientProperty");
            if (cp != null) {
                this.putClientProperty(((Object[])cp)[0], ((Object[])cp)[1]);
            }
            if ((name = UIDefaultsLookup.getString("TristateCheckBox.clearMixed.componentName")) != null) {
                this.setName(name);
            }
        }
    }
}

