require 'spec_helper'
RSpec.shared_examples_for 'Msf::Exploit::JSObfu' do

  subject(:jsobfu) do
    mod = ::Msf::Module.new
    mod.extend described_class
    mod
  end

  let (:js) do
    %Q|alert("hello, world");|
  end

  let(:default_jsobfuscate) do
    0
  end

  before do
    subject.datastore['JsObfuscate'] = default_jsobfuscate
  end

  context 'when iteration is set' do
    it 'returns a ::Rex::Exploitation::JSObfu object' do
      opts = {:iterations=>0}
      obj = jsobfu.js_obfuscate(js, opts)
      expect(obj).to be_kind_of(::Rex::Exploitation::JSObfu)
    end

    it 'does not obfuscate if iteration is 0' do
      opts = {:iterations=>0}
      obj = jsobfu.js_obfuscate(js, opts)
      expect(obj.to_s).to include js
    end

    it 'obfuscates if iteration is 1' do
      opts = {:iterations=>1}
      obj = jsobfu.js_obfuscate(js, opts)
      expect(obj.to_s).not_to include js
    end
  end

  context 'when iteration is nil' do
    let (:opts) do
      {:iterations=>nil}
    end

    it 'returns a ::Rex::Exploitation::JSObfu object' do
      obj = jsobfu.js_obfuscate(js, opts)
      expect(obj).to be_kind_of(::Rex::Exploitation::JSObfu)
    end

    it 'does not obfuscate' do
      obj = jsobfu.js_obfuscate(js, opts)
      expect(obj.to_s).to include(js)
    end
  end

end
