/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanPartOfSpeechStopFilter;
import org.apache.lucene.analysis.ko.POS;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.Analysis;

public class NoriPartOfSpeechStopFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<POS.Tag> stopTags;

    public NoriPartOfSpeechStopFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List tagList = Analysis.parseWordList((Environment)env, (Settings)settings, (String)"stoptags", s -> s);
        this.stopTags = tagList != null ? NoriPartOfSpeechStopFilterFactory.resolvePOSList(tagList) : KoreanPartOfSpeechStopFilter.DEFAULT_STOP_TAGS;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new KoreanPartOfSpeechStopFilter(tokenStream, this.stopTags);
    }

    static Set<POS.Tag> resolvePOSList(List<String> tagList) {
        HashSet<POS.Tag> stopTags = new HashSet<POS.Tag>();
        for (String tag : tagList) {
            stopTags.add(POS.resolveTag((String)tag));
        }
        return stopTags;
    }
}

