/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.CharClassRaw;
import com.plantuml.ubrex.CharClassType;
import com.plantuml.ubrex.TextNavigator;

public class CharClass {
    private final CharClassRaw charClassRaw;
    private final CharClassType type;

    public CharClass(CharClassRaw charClassRaw, CharClassType type) {
        this.charClassRaw = charClassRaw;
        this.type = type;
    }

    public boolean matches(char ch) {
        boolean rawMatch = this.charClassRaw.internalMatches(ch);
        if (this.type == CharClassType.NORMAL) {
            return rawMatch;
        }
        return !rawMatch;
    }

    public static CharClass fromDefinition(TextNavigator nav) {
        CharClassType type = Character.isUpperCase(nav.charAt(0)) ? CharClassType.NEGATIVE : CharClassType.NORMAL;
        CharClassRaw raw = CharClassRaw.fromDefinition(nav);
        return new CharClass(raw, type);
    }

    public String name() {
        return this.charClassRaw.name() + "-" + this.type.name();
    }

    public int getDefinitionLength() {
        return this.charClassRaw.getDefinitionLength();
    }
}

