/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

class FbDeflaterOutputStream
extends DeflaterOutputStream
implements EncryptedStreamSupport {
    private static final Logger log = LoggerFactory.getLogger(FbDeflaterOutputStream.class);
    private boolean encrypted;

    public FbDeflaterOutputStream(OutputStream out) {
        super(out, new Deflater(), true);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (log.isTraceEnabled()) {
                log.tracef("FbDeflaterOutputStream: Uncompressed bytes: %d to compressed bytes: %d", (Object)this.def.getBytesRead(), (Object)this.def.getBytesWritten());
            }
            this.def.end();
        }
    }

    @Override
    public void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Output stream already encrypted");
        }
        this.out = new CipherOutputStream(this.out, cipher);
        this.encrypted = true;
    }
}

