/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.code;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.ContinuationRootNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

@ExportLibrary(value=InteropLibrary.class)
public final class PCode
extends PythonBuiltinObject {
    public static final int CO_OPTIMIZED = 1;
    public static final int CO_NEWLOCALS = 2;
    public static final int CO_VARARGS = 4;
    public static final int CO_VARKEYWORDS = 8;
    public static final int CO_NESTED = 16;
    public static final int CO_GENERATOR = 32;
    public static final int CO_COROUTINE = 128;
    public static final int CO_ITERABLE_COROUTINE = 256;
    public static final int CO_ASYNC_GENERATOR = 512;
    public static final int CO_GRAALPYHON_MODULE = 4096;
    private final RootCallTarget callTarget;
    private final Signature signature;
    private int nlocals = -1;
    private int stacksize = -1;
    private int flags = -1;
    private Object[] constants;
    private TruffleString[] names;
    private TruffleString[] varnames;
    private TruffleString filename;
    private TruffleString name;
    private TruffleString qualname;
    private int firstlineno = -1;
    private byte[] linetable;
    private TruffleString[] freevars;
    private TruffleString[] cellvars;

    public PCode(Object cls, Shape instanceShape, RootCallTarget callTarget) {
        super(cls, instanceShape);
        this.callTarget = callTarget;
        this.signature = Signature.fromCallTarget(callTarget);
    }

    public PCode(Object cls, Shape instanceShape, RootCallTarget callTarget, int flags, int firstlineno, byte[] linetable, TruffleString filename) {
        this(cls, instanceShape, callTarget);
        this.flags = flags;
        this.firstlineno = firstlineno;
        this.linetable = linetable;
        this.filename = filename;
    }

    public PCode(Object cls, Shape instanceShape, RootCallTarget callTarget, Signature signature, BytecodeCodeUnit codeUnit) {
        this(cls, instanceShape, callTarget, signature, codeUnit.varnames.length, -1, -1, null, null, null, null, null, null, codeUnit.name, codeUnit.qualname, -1, codeUnit.srcOffsetTable);
    }

    public PCode(Object cls, Shape instanceShape, RootCallTarget callTarget, Signature signature, BytecodeDSLCodeUnit codeUnit) {
        this(cls, instanceShape, callTarget, signature, codeUnit.varnames.length, -1, -1, null, null, null, null, null, null, codeUnit.name, codeUnit.qualname, -1, null);
    }

    public PCode(Object cls, Shape instanceShape, RootCallTarget callTarget, Signature signature, int nlocals, int stacksize, int flags, Object[] constants, TruffleString[] names, TruffleString[] varnames, TruffleString[] freevars, TruffleString[] cellvars, TruffleString filename, TruffleString name, TruffleString qualname, int firstlineno, byte[] linetable) {
        super(cls, instanceShape);
        this.nlocals = nlocals;
        this.stacksize = stacksize;
        this.flags = flags;
        this.constants = constants;
        this.names = names;
        this.varnames = varnames;
        this.filename = filename;
        this.name = name;
        this.qualname = qualname;
        this.firstlineno = firstlineno;
        this.linetable = linetable;
        this.freevars = freevars;
        this.cellvars = cellvars;
        this.callTarget = callTarget;
        this.signature = signature;
        assert (signature != null);
    }

    private static TruffleString[] extractFreeVars(RootNode rootNode) {
        CodeUnit code = PCode.getCodeUnit(rootNode);
        if (code != null) {
            return Arrays.copyOf(code.freevars, code.freevars.length);
        }
        return PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
    }

    private static TruffleString[] extractCellVars(RootNode rootNode) {
        CodeUnit code = PCode.getCodeUnit(rootNode);
        if (code != null) {
            return Arrays.copyOf(code.cellvars, code.cellvars.length);
        }
        return PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
    }

    @CompilerDirectives.TruffleBoundary
    private static void setRootNodeFileName(RootNode rootNode, TruffleString filename) {
        RootNode funcRootNode = PCode.rootNodeForExtraction(rootNode);
        PythonContext.get((Node)rootNode).setCodeFilename((CallTarget)funcRootNode.getCallTarget(), filename);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString extractFileName(RootNode rootNode) {
        TruffleString filename;
        RootNode funcRootNode = PCode.rootNodeForExtraction(rootNode);
        PythonContext context = PythonContext.get((Node)rootNode);
        if (context != null) {
            filename = rootNode instanceof PBytecodeRootNode ? context.getCodeUnitFilename(((PBytecodeRootNode)rootNode).getCodeUnit()) : context.getCodeFilename((CallTarget)funcRootNode.getCallTarget());
        } else {
            return PythonUtils.toTruffleStringUncached(funcRootNode.getName());
        }
        if (filename != null) {
            return filename;
        }
        SourceSection src = funcRootNode.getSourceSection();
        String jFilename = src != null ? PCode.getSourceSectionFileName(src) : funcRootNode.getName();
        return PythonUtils.toTruffleStringUncached(jFilename);
    }

    @CompilerDirectives.TruffleBoundary
    private static String getSourceSectionFileName(SourceSection src) {
        if (src == null) {
            return null;
        }
        String path = src.getSource().getPath();
        if (path == null) {
            return src.getSource().getName();
        }
        return path;
    }

    @CompilerDirectives.TruffleBoundary
    private static int extractFirstLineno(RootNode rootNode) {
        RootNode funcRootNode = PCode.rootNodeForExtraction(rootNode);
        CodeUnit co = PCode.getCodeUnit(funcRootNode);
        if (co != null) {
            if ((co.flags & 0x1000) != 0) {
                return 1;
            }
            return co.startLine;
        }
        SourceSection sourceSection = funcRootNode.getSourceSection();
        if (sourceSection != null) {
            return sourceSection.getStartLine();
        }
        return 1;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString extractName(RootNode rootNode) {
        return PythonUtils.toTruffleStringUncached(rootNode.getName());
    }

    @CompilerDirectives.TruffleBoundary
    private static int extractStackSize(RootNode rootNode) {
        RootNode funcRootNode = PCode.rootNodeForExtraction(rootNode);
        if (funcRootNode instanceof PBytecodeRootNode) {
            PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)funcRootNode;
            BytecodeCodeUnit code = bytecodeRootNode.getCodeUnit();
            return code.stacksize + code.varnames.length + code.cellvars.length + code.freevars.length;
        }
        return funcRootNode.getFrameDescriptor().getNumberOfSlots();
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString[] extractVarnames(RootNode node) {
        CodeUnit code = PCode.getCodeUnit(node);
        if (code != null) {
            return Arrays.copyOf(code.varnames, code.varnames.length);
        }
        return PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] extractConstants(RootNode node) {
        RootNode rootNode = PCode.rootNodeForExtraction(node);
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            if (rootNode instanceof PBytecodeDSLRootNode) {
                PBytecodeDSLRootNode bytecodeDSLRootNode = (PBytecodeDSLRootNode)rootNode;
                BytecodeDSLCodeUnit co = bytecodeDSLRootNode.getCodeUnit();
                ArrayList<Object> constants = new ArrayList<Object>();
                for (int i = 0; i < co.constants.length; ++i) {
                    Object constant = PCode.convertConstantToPythonSpace(rootNode, co.constants[i]);
                    constants.add(constant);
                }
                return constants.toArray(new Object[0]);
            }
        } else if (rootNode instanceof PBytecodeRootNode) {
            OpCodes op;
            PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)rootNode;
            BytecodeCodeUnit co = bytecodeRootNode.getCodeUnit();
            HashSet<Comparable<Integer>> bytecodeConstants = new HashSet<Comparable<Integer>>();
            for (int bci = 0; bci < co.code.length; bci += op.length()) {
                op = OpCodes.fromOpCode(co.code[bci]);
                if (op.quickens != null) {
                    op = op.quickens;
                }
                if (op == OpCodes.LOAD_BYTE) {
                    bytecodeConstants.add(Integer.valueOf(Byte.toUnsignedInt(co.code[bci + 1])));
                    continue;
                }
                if (op == OpCodes.LOAD_NONE) {
                    bytecodeConstants.add(PNone.NONE);
                    continue;
                }
                if (op == OpCodes.LOAD_TRUE) {
                    bytecodeConstants.add(Boolean.valueOf(true));
                    continue;
                }
                if (op == OpCodes.LOAD_FALSE) {
                    bytecodeConstants.add(Boolean.valueOf(false));
                    continue;
                }
                if (op == OpCodes.LOAD_ELLIPSIS) {
                    bytecodeConstants.add(PEllipsis.INSTANCE);
                    continue;
                }
                if (op == OpCodes.LOAD_INT || op == OpCodes.LOAD_LONG) {
                    bytecodeConstants.add(Long.valueOf(co.primitiveConstants[Byte.toUnsignedInt(co.code[bci + 1])]));
                    continue;
                }
                if (op != OpCodes.LOAD_DOUBLE) continue;
                bytecodeConstants.add(Double.valueOf(Double.longBitsToDouble(co.primitiveConstants[Byte.toUnsignedInt(co.code[bci + 1])])));
            }
            ArrayList<Object> constants = new ArrayList<Object>();
            for (int i = 0; i < co.constants.length; ++i) {
                Object constant = PCode.convertConstantToPythonSpace(rootNode, co.constants[i]);
                if (constant == PNone.NONE && bytecodeConstants.contains(PNone.NONE)) continue;
                constants.add(constant);
            }
            constants.addAll(bytecodeConstants);
            return constants.toArray(new Object[0]);
        }
        return PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString[] extractNames(RootNode node) {
        CodeUnit code = PCode.getCodeUnit(node);
        if (code != null) {
            return Arrays.copyOf(code.names, code.names.length);
        }
        return PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
    }

    private static RootNode rootNodeForExtraction(RootNode rootNode) {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            if (rootNode instanceof PBytecodeDSLGeneratorFunctionRootNode) {
                PBytecodeDSLGeneratorFunctionRootNode generatorFunctionRootNode = (PBytecodeDSLGeneratorFunctionRootNode)rootNode;
                return generatorFunctionRootNode.getBytecodeRootNode();
            }
            if (rootNode instanceof ContinuationRootNode) {
                ContinuationRootNode generatorRootNode = (ContinuationRootNode)rootNode;
                return (RootNode)generatorRootNode.getSourceRootNode();
            }
        } else {
            if (rootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                PBytecodeGeneratorFunctionRootNode generatorFunctionRootNode = (PBytecodeGeneratorFunctionRootNode)rootNode;
                return generatorFunctionRootNode.getBytecodeRootNode();
            }
            if (rootNode instanceof PBytecodeGeneratorRootNode) {
                PBytecodeGeneratorRootNode generatorRootNode = (PBytecodeGeneratorRootNode)rootNode;
                return generatorRootNode.getBytecodeRootNode();
            }
        }
        return rootNode;
    }

    @CompilerDirectives.TruffleBoundary
    private static int extractFlags(RootNode node) {
        int flags = 0;
        CodeUnit code = PCode.getCodeUnit(node);
        if (code != null) {
            flags = code.flags;
        }
        return flags;
    }

    private static CodeUnit getCodeUnit(RootNode node) {
        RootNode rootNode = PCode.rootNodeForExtraction(node);
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            if (rootNode instanceof PBytecodeDSLRootNode) {
                PBytecodeDSLRootNode bytecodeDSLRootNode = (PBytecodeDSLRootNode)rootNode;
                return bytecodeDSLRootNode.getCodeUnit();
            }
        } else if (rootNode instanceof PBytecodeRootNode) {
            PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)rootNode;
            return bytecodeRootNode.getCodeUnit();
        }
        return null;
    }

    RootNode getRootNode() {
        return this.getRootCallTarget().getRootNode();
    }

    RootNode getRootNodeForExtraction() {
        return PCode.rootNodeForExtraction(this.getRootNode());
    }

    public TruffleString[] getFreeVars() {
        if (this.freevars == null) {
            this.freevars = PCode.extractFreeVars(this.getRootNode());
        }
        return this.freevars;
    }

    public TruffleString[] getCellVars() {
        if (this.cellvars == null) {
            this.cellvars = PCode.extractCellVars(this.getRootNode());
        }
        return this.cellvars;
    }

    public void setFilename(TruffleString filename) {
        CompilerAsserts.neverPartOfCompilation();
        this.filename = filename;
        RootNode rootNode = PCode.rootNodeForExtraction(this.getRootNode());
        PCode.setRootNodeFileName(rootNode, filename);
        if (rootNode instanceof PBytecodeRootNode) {
            PythonContext context = PythonContext.get((Node)rootNode);
            BytecodeCodeUnit co = ((PBytecodeRootNode)rootNode).getCodeUnit();
            context.setCodeUnitFilename(co, filename);
            for (int i = 0; i < co.constants.length; ++i) {
                if (!(co.constants[i] instanceof CodeUnit)) continue;
                context.setCodeUnitFilename((CodeUnit)co.constants[i], filename);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getFilename() {
        if (this.filename == null) {
            this.filename = PCode.extractFileName(this.getRootNode());
        }
        return this.filename;
    }

    public int getFirstLineNo() {
        if (this.firstlineno == -1) {
            this.firstlineno = PCode.extractFirstLineno(this.getRootNode());
        }
        return this.firstlineno;
    }

    @CompilerDirectives.TruffleBoundary
    public int lastiToLine(int lasti) {
        RootNode funcRootNode = PCode.rootNodeForExtraction(this.getRootNode());
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            if (funcRootNode instanceof PBytecodeDSLRootNode) {
                PBytecodeDSLRootNode bytecodeDSLRootNode = (PBytecodeDSLRootNode)funcRootNode;
                BytecodeNode bytecodeNode = bytecodeDSLRootNode.getBytecodeNode();
                return bytecodeDSLRootNode.bciToLine(PBytecodeDSLRootNode.lastiToBci(lasti, bytecodeNode), bytecodeNode);
            }
        } else if (funcRootNode instanceof PBytecodeRootNode) {
            PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)funcRootNode;
            return bytecodeRootNode.bciToLine(bytecodeRootNode.lastiToBci(lasti));
        }
        return -1;
    }

    public TruffleString getName() {
        if (this.name == null) {
            this.name = PCode.extractName(this.getRootNode());
        }
        return this.name;
    }

    public TruffleString getQualName() {
        if (this.qualname == null) {
            this.qualname = PCode.extractName(this.getRootNode());
        }
        return this.qualname;
    }

    public int getArgcount() {
        return this.signature.getMaxNumOfPositionalArgs();
    }

    public int getPositionalOnlyArgCount() {
        int positionalMarkIndex = this.signature.getPositionalOnlyArgIndex();
        return positionalMarkIndex == -1 ? 0 : positionalMarkIndex;
    }

    public int getKwonlyargcount() {
        return this.signature.getNumOfRequiredKeywords();
    }

    public int getNlocals() {
        if (this.nlocals == -1) {
            this.nlocals = this.getVarnames().length;
        }
        return this.nlocals;
    }

    public int getStacksize() {
        if (this.stacksize == -1) {
            this.stacksize = PCode.extractStackSize(this.getRootNode());
        }
        return this.stacksize;
    }

    public int getFlags() {
        if (this.flags == -1) {
            this.flags = PCode.extractFlags(this.getRootNode());
        }
        return this.flags;
    }

    public TruffleString[] getVarnames() {
        if (this.varnames == null) {
            this.varnames = PCode.extractVarnames(this.getRootNode());
        }
        return this.varnames;
    }

    public byte[] getCodestring() {
        RootNode rootNode = this.getRootNode();
        if (rootNode instanceof PRootNode) {
            return ((PRootNode)rootNode).getCode();
        }
        return PythonUtils.EMPTY_BYTE_ARRAY;
    }

    public CodeUnit getCodeUnit() {
        return PCode.getCodeUnit(this.getRootNode());
    }

    public Object[] getConstants() {
        if (this.constants == null) {
            this.constants = PCode.extractConstants(this.getRootNode());
        }
        return this.constants;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object convertConstantToPythonSpace(RootNode rootNode, Object o) {
        PythonLanguage language = PythonLanguage.get(null);
        if (o instanceof CodeUnit) {
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                BytecodeDSLCodeUnit code = (BytecodeDSLCodeUnit)o;
                PBytecodeDSLRootNode root = code.createRootNode(PythonContext.get((Node)rootNode), PCode.getSourceSection(rootNode).getSource());
                return PFactory.createCode(language, root.getCallTarget(), root.getSignature(), code);
            }
            BytecodeCodeUnit code = (BytecodeCodeUnit)o;
            PBytecodeRootNode bytecodeRootNode = PBytecodeRootNode.create(language, code, PCode.getSourceSection(rootNode).getSource());
            return PFactory.createCode(language, bytecodeRootNode.getCallTarget(), bytecodeRootNode.getSignature(), code);
        }
        if (o instanceof BigInteger) {
            return PFactory.createInt(language, (BigInteger)o);
        }
        if (o instanceof int[]) {
            return PFactory.createTuple(language, (int[])o);
        }
        if (o instanceof long[]) {
            return PFactory.createTuple(language, new LongSequenceStorage((long[])o));
        }
        if (o instanceof double[]) {
            return PFactory.createTuple(language, new DoubleSequenceStorage((double[])o));
        }
        if (o instanceof boolean[]) {
            return PFactory.createTuple(language, new BoolSequenceStorage((boolean[])o));
        }
        if (o instanceof byte[]) {
            return PFactory.createBytes(language, (byte[])o);
        }
        if (o instanceof TruffleString[]) {
            TruffleString[] strings = (TruffleString[])o;
            Object[] array = new Object[strings.length];
            System.arraycopy(strings, 0, array, 0, strings.length);
            return PFactory.createTuple(language, array);
        }
        if (o instanceof Object[]) {
            Object[] objects = (Object[])o;
            return PFactory.createTuple(language, (Object[])objects.clone());
        }
        assert (!IsForeignObjectNode.executeUncached(o)) : o;
        return o;
    }

    @CompilerDirectives.TruffleBoundary
    private static SourceSection getSourceSection(RootNode rootNode) {
        return rootNode.getSourceSection();
    }

    public TruffleString[] getNames() {
        if (this.names == null) {
            this.names = PCode.extractNames(this.getRootNode());
        }
        return this.names;
    }

    public byte[] getLinetable() {
        return this.linetable;
    }

    public boolean isGenerator() {
        return (this.getFlags() & 0x20) > 0;
    }

    public static boolean isModule(int flags) {
        return (flags & 0x1000) > 0;
    }

    static boolean takesVarArgs(int flags) {
        return (flags & 4) > 0;
    }

    static boolean takesVarKeywordArgs(int flags) {
        return (flags & 8) > 0;
    }

    public boolean takesVarArgs() {
        return PCode.takesVarArgs(this.getFlags());
    }

    public boolean takesVarKeywordArgs() {
        return PCode.takesVarKeywordArgs(this.getFlags());
    }

    public Signature getSignature() {
        return this.signature;
    }

    public RootCallTarget getRootCallTarget() {
        return this.callTarget;
    }

    @ExportMessage
    public SourceSection getSourceLocation(@Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            SourceSection result = this.readSourceLocation();
            if (result != null) {
                SourceSection sourceSection = result;
                return sourceSection;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private SourceSection readSourceLocation() {
        return this.getRootNode().getSourceSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasSourceLocation(@Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = this.readSourceLocation() != null;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        String codeName = this.getName() == null ? "None" : this.getName().toJavaStringUncached();
        String codeFilename = PCode.getSourceSectionFileName(PCode.rootNodeForExtraction(this.getRootNode()).getSourceSection());
        if (codeFilename == null) {
            codeFilename = "None";
        }
        int codeFirstLineNo = this.getFirstLineNo() == 0 ? -1 : this.getFirstLineNo();
        return String.format("<code object %s, file \"%s\", line %d>", codeName, codeFilename, codeFirstLineNo);
    }

    @CompilerDirectives.TruffleBoundary
    public String toDisassembledString(boolean quickened) {
        RootNode rootNode = this.getRootCallTarget().getRootNode();
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER && rootNode instanceof PBytecodeDSLRootNode) {
            PBytecodeDSLRootNode dslRoot = (PBytecodeDSLRootNode)rootNode;
            return dslRoot.getCodeUnit().toString(quickened);
        }
        if (rootNode instanceof PBytecodeGeneratorRootNode) {
            PBytecodeGeneratorRootNode r = (PBytecodeGeneratorRootNode)rootNode;
            rootNode = r.getBytecodeRootNode();
        } else if (rootNode instanceof PBytecodeGeneratorFunctionRootNode) {
            PBytecodeGeneratorFunctionRootNode r = (PBytecodeGeneratorFunctionRootNode)rootNode;
            rootNode = r.getBytecodeRootNode();
        }
        if (rootNode instanceof PBytecodeRootNode) {
            PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)rootNode;
            return bytecodeRootNode.getCodeUnit().toString(quickened);
        }
        return "";
    }

    private static PTuple createTuple(PythonLanguage language, Object[] array) {
        Object[] data = array;
        if (data == null) {
            data = PythonUtils.EMPTY_OBJECT_ARRAY;
        }
        return PFactory.createTuple(language, data);
    }

    private static PBytes createBytes(byte[] array, PythonLanguage language) {
        byte[] bytes = array;
        if (bytes == null) {
            bytes = PythonUtils.EMPTY_BYTE_ARRAY;
        }
        return PFactory.createBytes(language, bytes);
    }

    public TruffleString co_name() {
        TruffleString codeName = this.getName();
        assert (codeName != null) : "PCode.co_name cannot be null!";
        return codeName;
    }

    public TruffleString co_qualname() {
        TruffleString qualName = this.getQualName();
        assert (qualName != null) : "PCode.co_qualname cannot be null!";
        return qualName;
    }

    public TruffleString co_filename() {
        TruffleString fName = this.getFilename();
        assert (fName != null) : "PCode.co_filename cannot be null";
        return fName;
    }

    public PBytes co_code(PythonLanguage language) {
        return PCode.createBytes(this.getCodestring(), language);
    }

    public PBytes co_lnotab(PythonLanguage language) {
        return PCode.createBytes(this.getLinetable(), language);
    }

    public PTuple co_consts(PythonLanguage language) {
        return PCode.createTuple(language, this.getConstants());
    }

    public PTuple co_names(PythonLanguage language) {
        return PCode.createTuple(language, this.getNames());
    }

    public PTuple co_varnames(PythonLanguage language) {
        return PCode.createTuple(language, this.getVarnames());
    }

    public PTuple co_freevars(PythonLanguage language) {
        return PCode.createTuple(language, this.getFreeVars());
    }

    public PTuple co_cellvars(PythonLanguage language) {
        return PCode.createTuple(language, this.getCellVars());
    }

    public int co_argcount() {
        return this.getArgcount();
    }

    public int co_posonlyargcount() {
        return this.getPositionalOnlyArgCount();
    }

    public int co_kwonlyargcount() {
        return this.getKwonlyargcount();
    }

    public int co_nlocals() {
        return this.getNlocals();
    }

    public int co_flags() {
        return this.getFlags();
    }

    public int co_firstlineno() {
        return this.getFirstLineNo();
    }

    public int co_stacksize() {
        return this.getStacksize();
    }
}

