/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Table;
import us.fatehi.utility.PrefixMatches;

final class TableMatchKeys {
    private final PrefixMatches matchKeysForTable;

    private static PrefixMatches analyzeTables(List<Table> tables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tables) {
            tableNames.add(table.getName());
        }
        return new PrefixMatches(tableNames, "_");
    }

    TableMatchKeys(List<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        this.matchKeysForTable = TableMatchKeys.analyzeTables(tables);
    }

    public List<String> get(Table table) {
        if (table == null) {
            return null;
        }
        return this.matchKeysForTable.get(table.getName());
    }

    public String toString() {
        return this.matchKeysForTable.toString();
    }
}

