/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.MAC;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

abstract class HMAC
implements MAC {
    protected String name;
    protected int bsize;
    protected String algorithm;
    private Mac mac;
    private final byte[] tmp = new byte[4];

    HMAC() {
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(byte[] byArray) throws Exception {
        Object object;
        if (byArray.length > this.bsize) {
            object = new byte[this.bsize];
            System.arraycopy(byArray, 0, object, 0, this.bsize);
            byArray = object;
        }
        object = new SecretKeySpec(byArray, this.algorithm);
        this.mac = Mac.getInstance(this.algorithm);
        this.mac.init((Key)object);
    }

    @Override
    public void update(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    @Override
    public void doFinal(byte[] byArray, int n) {
        try {
            this.mac.doFinal(byArray, n);
        }
        catch (ShortBufferException shortBufferException) {
            System.err.println(shortBufferException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

