﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>

namespace Aws {
namespace WellArchitected {
namespace Model {
enum class MetricType { NOT_SET, WORKLOAD };

namespace MetricTypeMapper {
AWS_WELLARCHITECTED_API MetricType GetMetricTypeForName(const Aws::String& name);

AWS_WELLARCHITECTED_API Aws::String GetNameForMetricType(MetricType value);
}  // namespace MetricTypeMapper
}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
