/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;

public final class GlyphClassTable
extends GlyphMappingTable
implements GlyphClassMapping {
    public static final int GLYPH_CLASS_TYPE_EMPTY = 0;
    public static final int GLYPH_CLASS_TYPE_MAPPED = 1;
    public static final int GLYPH_CLASS_TYPE_RANGE = 2;
    public static final int GLYPH_CLASS_TYPE_COVERAGE_SET = 3;
    private GlyphClassMapping cm;

    private GlyphClassTable(GlyphClassMapping cm) {
        assert (cm != null);
        assert (cm instanceof GlyphMappingTable);
        this.cm = cm;
    }

    @Override
    public int getType() {
        return ((GlyphMappingTable)((Object)this.cm)).getType();
    }

    @Override
    public List getEntries() {
        return ((GlyphMappingTable)((Object)this.cm)).getEntries();
    }

    @Override
    public int getClassSize(int set) {
        return this.cm.getClassSize(set);
    }

    @Override
    public int getClassIndex(int gid, int set) {
        return this.cm.getClassIndex(gid, set);
    }

    public static GlyphClassTable createClassTable(List entries) {
        GlyphMappingTable cm = entries == null || entries.size() == 0 ? new EmptyClassTable(entries) : (GlyphClassTable.isMappedClass(entries) ? new MappedClassTable(entries) : (GlyphClassTable.isRangeClass(entries) ? new RangeClassTable(entries) : (GlyphClassTable.isCoverageSetClass(entries) ? new CoverageSetClassTable(entries) : null)));
        assert (cm != null) : "unknown class type";
        return new GlyphClassTable((GlyphClassMapping)((Object)cm));
    }

    private static boolean isMappedClass(List entries) {
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (Object o : entries) {
            if (o instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static boolean isRangeClass(List entries) {
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (Object o : entries) {
            if (o instanceof GlyphMappingTable.MappingRange) continue;
            return false;
        }
        return true;
    }

    private static boolean isCoverageSetClass(List entries) {
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (Object o : entries) {
            if (o instanceof GlyphCoverageTable) continue;
            return false;
        }
        return true;
    }

    private static class CoverageSetClassTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphClassMapping {
        private static final Log LOG = LogFactory.getLog(CoverageSetClassTable.class);

        public CoverageSetClassTable(List entries) {
            LOG.warn((Object)"coverage set class table not yet supported");
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public int getClassSize(int set) {
            return 0;
        }

        @Override
        public int getClassIndex(int gid, int set) {
            return -1;
        }
    }

    private static class RangeClassTable
    extends GlyphMappingTable.RangeMappingTable
    implements GlyphClassMapping {
        public RangeClassTable(List entries) {
            super(entries);
        }

        @Override
        public int getMappedIndex(int gid, int s, int m) {
            return m;
        }

        @Override
        public int getClassSize(int set) {
            return this.getMappingSize();
        }

        @Override
        public int getClassIndex(int gid, int set) {
            return this.getMappedIndex(gid);
        }
    }

    private static class MappedClassTable
    extends GlyphMappingTable.MappedMappingTable
    implements GlyphClassMapping {
        private int firstGlyph;
        private int[] gca;
        private int gcMax = -1;

        public MappedClassTable(List entries) {
            this.populate(entries);
        }

        @Override
        public List getEntries() {
            ArrayList<Integer> entries = new ArrayList<Integer>();
            entries.add(this.firstGlyph);
            if (this.gca != null) {
                for (int aGca : this.gca) {
                    entries.add(aGca);
                }
            }
            return entries;
        }

        @Override
        public int getMappingSize() {
            return this.gcMax + 1;
        }

        @Override
        public int getMappedIndex(int gid) {
            int i = gid - this.firstGlyph;
            if (i >= 0 && i < this.gca.length) {
                return this.gca[i];
            }
            return -1;
        }

        @Override
        public int getClassSize(int set) {
            return this.getMappingSize();
        }

        @Override
        public int getClassIndex(int gid, int set) {
            return this.getMappedIndex(gid);
        }

        private void populate(List entries) {
            Iterator it = entries.iterator();
            int firstGlyph = 0;
            if (it.hasNext()) {
                Object o = it.next();
                if (o instanceof Integer) {
                    firstGlyph = (Integer)o;
                } else {
                    throw new AdvancedTypographicTableFormatException("illegal entry, first entry must be Integer denoting first glyph value, but is: " + o);
                }
            }
            int i = 0;
            int n = entries.size() - 1;
            int gcMax = -1;
            int[] gca = new int[n];
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof Integer) {
                    int gc = (Integer)o;
                    gca[i++] = gc;
                    if (gc <= gcMax) continue;
                    gcMax = gc;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal mapping entry, must be Integer: " + o);
            }
            assert (i == n);
            assert (this.gca == null);
            this.firstGlyph = firstGlyph;
            this.gca = gca;
            this.gcMax = gcMax;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ firstGlyph = " + this.firstGlyph + ", classes = {");
            int n = this.gca.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Integer.toString(this.gca[i]));
            }
            sb.append("} }");
            return sb.toString();
        }
    }

    private static class EmptyClassTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphClassMapping {
        public EmptyClassTable(List entries) {
            super(entries);
        }

        @Override
        public int getClassSize(int set) {
            return 0;
        }

        @Override
        public int getClassIndex(int gid, int set) {
            return -1;
        }
    }
}

