/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.CompareConditionAdapter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

class NodeLevelCompareCondition
extends CompareConditionAdapter {
    static final String COMPARATION_RESULT = "COMPARATION_RESULT";
    static final String NAME = "node_level_condition";
    static final String SUCCEED = "SUCCEED";
    static final String VALUE = "VALUE";
    private final int comparationResult;
    private final boolean succeed;

    static ASelectableCondition load(XMLElement element) {
        return new NodeLevelCompareCondition(element.getAttribute(VALUE, null), TreeXmlReader.xmlToBoolean(element.getAttribute("MATCH_CASE", null)), Integer.parseInt(element.getAttribute(COMPARATION_RESULT, null)), TreeXmlReader.xmlToBoolean(element.getAttribute(SUCCEED, null)));
    }

    NodeLevelCompareCondition(String value, boolean matchCase, int comparationResult, boolean succeed) {
        super(Long.valueOf(value));
        this.comparationResult = comparationResult;
        this.succeed = succeed;
    }

    @Override
    public boolean isEqualityCondition() {
        return this.comparationResult == 0;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        long level = node.getNodeLevel();
        return this.succeed == (this.compareTo(level) == this.comparationResult);
    }

    private boolean checkLevel(long level) {
        return this.succeed == (this.compareTo(level) == this.comparationResult);
    }

    @Override
    protected String createDescription() {
        String nodeCondition = TextUtils.getText("filter_node_level");
        return super.createDescription(nodeCondition, this.comparationResult, this.succeed);
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String nodeCondition = TextUtils.getText("filter_node_level");
        return this.createRenderedIcons(nodeCondition, this.comparationResult, this.succeed, fontMetrics);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(COMPARATION_RESULT, Integer.toString(this.comparationResult));
        child.setAttribute(SUCCEED, TreeXmlWriter.BooleanToXml(this.succeed));
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

