/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;

@SelectableAction(checkOnPopup=true)
@EnabledAction(checkOnNodeChange=true)
public class SetStringMapViewPropertyAction
extends AFreeplaneAction {
    private static final String AS_DEFAULT = "(default)";
    private final String propertyName;
    private final String propertyValue;
    private final String property;
    private final boolean isDefault;

    private static String extractPropertyWithOption(String argument) {
        boolean isDefault = argument.endsWith(AS_DEFAULT);
        String property = isDefault ? argument.substring(0, argument.length() - AS_DEFAULT.length()).trim() : argument;
        return property;
    }

    public SetStringMapViewPropertyAction(String argument) {
        super("SetStringMapViewPropertyAction." + SetStringMapViewPropertyAction.extractPropertyWithOption(argument), TextUtils.getRawText("OptionPanel." + SetStringMapViewPropertyAction.extractPropertyWithOption(argument)), null);
        this.property = SetStringMapViewPropertyAction.extractPropertyWithOption(argument);
        int separatorIndex = this.property.indexOf(46);
        this.propertyName = this.property.substring(0, separatorIndex);
        this.propertyValue = this.property.substring(separatorIndex + 1);
        this.isDefault = this.property != argument;
        String propertyWithOption = SetStringMapViewPropertyAction.extractPropertyWithOption(argument);
        this.setIcon(propertyWithOption + ".icon");
        this.setTooltip(this.getTooltipKey());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent mapViewComponent = this.getMapViewComponent();
        if (mapViewComponent != null) {
            Object value = mapViewComponent.getClientProperty(this.propertyName);
            mapViewComponent.putClientProperty(this.propertyName, this.propertyValue);
            this.setSelected(true);
        }
    }

    private JComponent getMapViewComponent() {
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        return mapViewComponent;
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.property;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        try {
            JComponent mapViewComponent = this.getMapViewComponent();
            if (mapViewComponent != null) {
                Object currentValue = mapViewComponent.getClientProperty(this.propertyName);
                boolean isSet = currentValue == null && this.isDefault || this.propertyValue.equals(currentValue);
                this.setSelected(isSet);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSelected(false);
    }

    @Override
    public void setEnabled() {
        this.setEnabled(this.getMapViewComponent() != null);
    }
}

