/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.model.output.TokenUsage;
import java.util.function.Supplier;
import javax.swing.SwingWorker;
import org.freeplane.plugin.ai.chat.AIChatService;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.ChatMemoryRenderEntry;
import org.freeplane.plugin.ai.chat.ChatRequestCancellation;
import org.freeplane.plugin.ai.chat.ChatTokenUsageTracker;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;

class ChatRequestFlow {
    private final RequestCallbacks callbacks;
    private final ChatRequestCancellation requestCancellation;
    private final ChatTokenUsageTracker tokenUsageTracker;
    private AssistantProfileChatMemory chatMemory;
    private SwingWorker<String, Void> activeWorker;
    private boolean requestInProgress;
    private int activeRequestId;
    private int snapshotChatSize;
    private String snapshotUserText;
    private TokenUsage responseUsage;
    private String requestFailureMessage;

    ChatRequestFlow(RequestCallbacks callbacks, ChatTokenUsageTracker tokenUsageTracker) {
        this.callbacks = callbacks;
        this.tokenUsageTracker = tokenUsageTracker;
        this.requestCancellation = new ChatRequestCancellation();
    }

    boolean isRequestActive() {
        return this.requestInProgress;
    }

    Supplier<Boolean> cancellationSupplier() {
        return this.requestCancellation::isCancelled;
    }

    void refreshTokenCounters() {
        this.callbacks.refreshTokenCounters();
    }

    void updateChatMemory(AssistantProfileChatMemory chatMemory) {
        this.chatMemory = chatMemory;
    }

    void onToolCallSummary(ToolCallSummary summary) {
        if (summary == null || !this.callbacks.isToolCallHistoryVisible()) {
            return;
        }
        if (this.chatMemory != null) {
            this.chatMemory.addToolCallSummary(summary.getSummaryText(), summary.getToolCaller());
        }
        this.callbacks.onToolSummaryAppended(ChatMemoryRenderEntry.forToolSummary(summary.getSummaryText(), summary.getToolCaller()));
    }

    void onProviderUsage(TokenUsage usage) {
        if (usage != null && this.tokenUsageTracker != null) {
            this.tokenUsageTracker.recordProviderUsage(usage);
        }
        this.responseUsage = usage;
    }

    void beginRequest(String userMessage) {
        this.requestCancellation.reset();
        ++this.activeRequestId;
        this.snapshotUserText = userMessage;
        this.snapshotChatSize = this.callbacks.snapshotMemorySize();
        this.requestFailureMessage = null;
        this.requestInProgress = true;
        this.callbacks.onRequestStarted();
    }

    void submitRequest(AIChatService chatService) {
        this.executeRequestWorker(chatService, this.snapshotUserText, this.activeRequestId);
    }

    void captureChatSnapshot() {
        this.snapshotChatSize = this.callbacks.snapshotMemorySize();
    }

    void cancelActiveRequest() {
        if (!this.isRequestActive()) {
            return;
        }
        this.requestCancellation.cancel();
        ++this.activeRequestId;
        if (this.activeWorker != null) {
            this.activeWorker.cancel(true);
        }
        this.requestInProgress = false;
        this.restoreChatSnapshot();
    }

    void restoreChatSnapshot() {
        this.callbacks.truncateMemoryToSize(this.snapshotChatSize);
        this.callbacks.synchronizeTranscriptWithMemory();
        this.callbacks.rebuildHistoryFromTranscript();
        this.activeWorker = null;
        this.requestInProgress = false;
        this.callbacks.onUserTextRestored(this.snapshotUserText);
        if (this.requestFailureMessage != null) {
            this.callbacks.onRequestFailed(this.snapshotUserText, this.requestFailureMessage);
        }
        this.callbacks.onRequestFinished();
        this.callbacks.refreshTokenCounters();
        this.clearRequestState();
    }

    void resetRequestState() {
        this.clearRequestState();
    }

    private void executeRequestWorker(final AIChatService chatService, final String userMessage, final int requestId) {
        this.activeWorker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() {
                return chatService.chat(userMessage);
            }

            @Override
            protected void done() {
                if (requestId != ChatRequestFlow.this.activeRequestId || ChatRequestFlow.this.requestCancellation.isCancelled()) {
                    return;
                }
                try {
                    ChatRequestFlow.this.callbacks.onAssistantResponse((String)this.get());
                    ChatRequestFlow.this.finishRequest();
                }
                catch (Exception error) {
                    ChatRequestFlow.this.requestFailureMessage = ChatRequestFlow.this.normalizeErrorMessage(error);
                    ChatRequestFlow.this.callbacks.onAssistantError(ChatRequestFlow.this.requestFailureMessage);
                    ChatRequestFlow.this.restoreChatSnapshot();
                }
            }
        };
        this.activeWorker.execute();
    }

    private String normalizeErrorMessage(Exception error) {
        Throwable rootCause = this.rootCause(error);
        String message = rootCause.getMessage();
        if (message == null || message.trim().isEmpty()) {
            return rootCause.getClass().getSimpleName();
        }
        return message;
    }

    private Throwable rootCause(Throwable error) {
        Throwable current;
        for (current = error; current.getCause() != null && current.getCause() != current; current = current.getCause()) {
        }
        return current;
    }

    private void finishRequest() {
        this.applyPostResponseCompaction();
        this.activeWorker = null;
        this.requestInProgress = false;
        this.callbacks.onRequestFinished();
        this.clearRequestState();
    }

    private void clearRequestState() {
        this.snapshotChatSize = 0;
        this.snapshotUserText = null;
        this.responseUsage = null;
        this.requestFailureMessage = null;
    }

    private void applyPostResponseCompaction() {
        boolean evicted;
        boolean bl = evicted = this.chatMemory != null && this.chatMemory.onResponseTokenUsage(this.responseUsage);
        if (evicted) {
            this.callbacks.onPostResponseEviction();
        }
    }

    static interface RequestCallbacks {
        public void onRequestStarted();

        public void onRequestFinished();

        public void onUserTextRestored(String var1);

        public void onRequestFailed(String var1, String var2);

        public void onAssistantResponse(String var1);

        public void onAssistantError(String var1);

        public int snapshotMemorySize();

        public void truncateMemoryToSize(int var1);

        public void synchronizeTranscriptWithMemory();

        public void rebuildHistoryFromTranscript();

        public boolean evictOldestTurn();

        public void onPostResponseEviction();

        public void refreshTokenCounters();

        public boolean isToolCallHistoryVisible();

        public void onToolSummaryAppended(ChatMemoryRenderEntry var1);
    }
}

