/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.edits;

import java.util.LinkedHashMap;
import java.util.Map;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeIterator;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.edits.AIEdits;

public class AiEditsMarkerRemoval {
    public Map<NodeModel, AIEdits> collectNodesWithAiEdits(NodeModel rootNode) {
        LinkedHashMap<NodeModel, AIEdits> removedEditsByNode = new LinkedHashMap<NodeModel, AIEdits>();
        if (rootNode == null) {
            return removedEditsByNode;
        }
        NodeIterator iterator = NodeIterator.of((Object)rootNode, NodeModel::getChildren);
        while (iterator.hasNext()) {
            NodeModel node = (NodeModel)iterator.next();
            AIEdits aiEdits = (AIEdits)node.getExtension(AIEdits.class);
            if (aiEdits == null) continue;
            removedEditsByNode.put(node, aiEdits);
        }
        return removedEditsByNode;
    }

    public Map<NodeModel, AIEdits> collectNodesWithAiEdits(Iterable<NodeModel> nodes) {
        LinkedHashMap<NodeModel, AIEdits> removedEditsByNode = new LinkedHashMap<NodeModel, AIEdits>();
        if (nodes == null) {
            return removedEditsByNode;
        }
        for (NodeModel node : nodes) {
            AIEdits aiEdits;
            if (node == null || (aiEdits = (AIEdits)node.getExtension(AIEdits.class)) == null) continue;
            removedEditsByNode.put(node, aiEdits);
        }
        return removedEditsByNode;
    }

    public IActor createUndoableRemoval(final Map<NodeModel, AIEdits> removedEditsByNode, final MapController mapController, final String description) {
        return new IActor(){

            public void act() {
                AiEditsMarkerRemoval.this.removeAiEdits(removedEditsByNode, mapController);
            }

            public void undo() {
                AiEditsMarkerRemoval.this.restoreAiEdits(removedEditsByNode, mapController);
            }

            public String getDescription() {
                return description == null ? "" : description;
            }
        };
    }

    private void removeAiEdits(Map<NodeModel, AIEdits> removedEditsByNode, MapController mapController) {
        if (removedEditsByNode == null || mapController == null) {
            return;
        }
        for (Map.Entry<NodeModel, AIEdits> entry : removedEditsByNode.entrySet()) {
            NodeModel node = entry.getKey();
            AIEdits existingEdits = entry.getValue();
            node.removeExtension(AIEdits.class);
            mapController.nodeChanged(node, AIEdits.class, (Object)existingEdits, null);
        }
    }

    private void restoreAiEdits(Map<NodeModel, AIEdits> removedEditsByNode, MapController mapController) {
        if (removedEditsByNode == null || mapController == null) {
            return;
        }
        for (Map.Entry<NodeModel, AIEdits> entry : removedEditsByNode.entrySet()) {
            NodeModel node = entry.getKey();
            AIEdits existingEdits = entry.getValue();
            node.addExtension((IExtension)existingEdits);
            mapController.nodeChanged(node, AIEdits.class, null, (Object)existingEdits);
        }
    }
}

