/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import docking.widgets.AutoLookup;
import docking.widgets.list.GList;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

public class GListAutoLookup<T>
extends AutoLookup {
    private GList<T> list;

    public GListAutoLookup(GList<T> list) {
        this.list = list;
    }

    @Override
    public int getCurrentRow() {
        return this.list.getSelectedIndex();
    }

    @Override
    public int getRowCount() {
        return this.list.getModel().getSize();
    }

    @Override
    public String getValueString(int row, int col) {
        ListCellRenderer<T> renderer = this.list.getCellRenderer();
        Object value = this.list.getModel().getElementAt(row);
        if (!(renderer instanceof JLabel)) {
            return value.toString();
        }
        Component c = renderer.getListCellRendererComponent(this.list, value, row, false, false);
        return ((JLabel)c).getText();
    }

    @Override
    public boolean isSorted(int column) {
        return true;
    }

    @Override
    public boolean isSortedAscending() {
        return true;
    }

    @Override
    public void matchFound(int row) {
        this.list.setSelectedIndex(row);
    }
}

