/*
 * Decompiled with CFR 0.152.
 */
package resources;

import generic.util.image.ImageUtils;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class IconProvider {
    private Icon icon;
    private URL url;
    private URL tempUrl;
    private boolean tempFileFailed;

    public IconProvider(Icon icon, URL url) {
        this.icon = icon;
        this.url = url;
    }

    public Image getImage() {
        ImageIcon imageIcon = ResourceManager.getImageIcon(this.icon);
        return imageIcon.getImage();
    }

    public boolean isInvalid() {
        return this.icon == null;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getOrCreateUrl() {
        if (this.url != null) {
            return this.url;
        }
        this.createTempUrlAsNeeded();
        return this.tempUrl;
    }

    private void createTempUrlAsNeeded() {
        if (this.testUrl(this.tempUrl)) {
            return;
        }
        this.tempUrl = this.createTempUrl();
        if (this.tempUrl == null) {
            this.tempUrl = this.getDefaultUrl();
        }
    }

    private URL createTempUrl() {
        if (this.tempFileFailed) {
            return null;
        }
        try {
            File imageFile = Application.createTempFile((String)"temp.help.icon", null);
            imageFile.deleteOnExit();
            ImageIcon imageIcon = ResourceManager.getImageIcon(this.icon);
            ImageUtils.writeFile(imageIcon.getImage(), imageFile);
            return imageFile.toURI().toURL();
        }
        catch (IOException e) {
            this.tempFileFailed = true;
            Msg.error((Object)this, (Object)("Unable to write temp image to display in help for " + ResourceManager.getIconName(this.icon)));
            return null;
        }
    }

    private boolean testUrl(URL testUrl) {
        if (testUrl == null) {
            return false;
        }
        try {
            return new File(testUrl.toURI()).exists();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private URL getDefaultUrl() {
        return ResourceManager.getResource("images/core.png");
    }
}

