/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ThunkedFunctionFieldLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;

public class ThunkedFunctionFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Thunked-Function";

    public ThunkedFunctionFieldFactory() {
        super(FIELD_NAME);
    }

    public ThunkedFunctionFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hlProvider, (Options)displayOptions, (Options)fieldOptions);
    }

    private Color getThunkedFunctionNameColor(Function thunkedFunction) {
        if (!thunkedFunction.isExternal()) {
            return ListingColors.SEPARATOR;
        }
        ExternalLocation externalLocation = thunkedFunction.getExternalLocation();
        String libName = externalLocation.getLibraryName();
        if ("<EXTERNAL>".equals(libName)) {
            return ListingColors.EXT_REF_UNRESOLVED;
        }
        ExternalManager externalManager = thunkedFunction.getProgram().getExternalManager();
        String path = externalManager.getExternalLibraryPath(libName);
        if (path == null || path.length() == 0) {
            return ListingColors.EXT_REF_UNRESOLVED;
        }
        return ListingColors.EXT_REF_RESOLVED;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        Function f = (Function)obj;
        Function thunkedFunction = f.getThunkedFunction(false);
        if (thunkedFunction == null) {
            return null;
        }
        ArrayList<TextFieldElement> textElements = new ArrayList<TextFieldElement>();
        int elementIndex = 0;
        AttributedString as = new AttributedString("Thunked-Function: ", (Color)ListingColors.SEPARATOR, this.getMetrics());
        textElements.add(new TextFieldElement(as, elementIndex++, 0));
        String functionName = this.simplifyTemplates(thunkedFunction.getName(true));
        as = new AttributedString(functionName, this.getThunkedFunctionNameColor(thunkedFunction), this.getMetrics());
        textElements.add(new TextFieldElement(as, elementIndex++, 0));
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)new CompositeFieldElement(textElements), this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof FunctionProxy) {
            FunctionProxy functionProxy = (FunctionProxy)proxy;
            Function function = functionProxy.getObject();
            Function thunkedFunction = function.getThunkedFunction(false);
            return new ThunkedFunctionFieldLocation(function.getProgram(), functionProxy.getLocationAddress(), functionProxy.getFunctionAddress(), thunkedFunction != null ? thunkedFunction.getEntryPoint() : null, col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof ThunkedFunctionFieldLocation) {
            ThunkedFunctionFieldLocation thunkFunctionLoc = (ThunkedFunctionFieldLocation)loc;
            return new FieldLocation(index, fieldNum, 0, thunkFunctionLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions pDisplayOptions, ToolOptions fieldOptions) {
        return new ThunkedFunctionFieldFactory(formatModel, provider, pDisplayOptions, fieldOptions);
    }
}

