/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.net.HttpClients;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pdb.symbolserver.AbstractSymbolServer;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInputStream;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;

public class HttpSymbolServer
extends AbstractSymbolServer
implements SymbolServer.MutableTrust {
    private static final String GHIDRA_USER_AGENT = "Ghidra_HttpSymbolServer_client";
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_REQUEST_TIMEOUT_MS = 10000;
    private static final Pattern NAMEPAT = Pattern.compile("(\\!?)(http(s?)://.*)");
    private final URI serverURI;
    private boolean trusted;

    public static boolean isHttpSymbolServerLocation(String locationString) {
        return NAMEPAT.matcher(locationString).matches();
    }

    public static SymbolServer createInstance(String locationString, SymbolServerInstanceCreatorContext context) {
        Matcher m = NAMEPAT.matcher(locationString);
        if (!m.matches()) {
            return null;
        }
        boolean isTrusted = "!".equals(m.group(1));
        String url = m.group(2);
        return new HttpSymbolServer(URI.create(url), isTrusted);
    }

    public static HttpSymbolServer createTrusted(String url) {
        return new HttpSymbolServer(URI.create(url), true);
    }

    public static HttpSymbolServer createUntrusted(String url) {
        return new HttpSymbolServer(URI.create(url), false);
    }

    public HttpSymbolServer(URI serverURI) {
        this(serverURI, false);
    }

    public HttpSymbolServer(URI serverURI, boolean isTrusted) {
        String path = serverURI.getPath();
        this.serverURI = path.endsWith("/") ? serverURI : serverURI.resolve(serverURI.getPath() + "/");
        this.trusted = isTrusted;
    }

    @Override
    public String getName() {
        return (this.trusted ? "!" : "") + this.serverURI.toString();
    }

    @Override
    public String getDescriptiveName() {
        return this.serverURI.toString();
    }

    @Override
    public boolean isValid(TaskMonitor monitor) {
        return this.exists("", monitor) || this.exists("pingme.txt", monitor);
    }

    private HttpRequest.Builder request(String str) throws IOException {
        try {
            return HttpRequest.newBuilder(this.serverURI.resolve(str)).setHeader("User-Agent", GHIDRA_USER_AGENT);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean exists(String filename, TaskMonitor monitor) {
        try {
            HttpRequest request = this.request(filename).timeout(Duration.ofMillis(10000L)).method("HEAD", HttpRequest.BodyPublishers.noBody()).build();
            Msg.debug((Object)this, (Object)(this.logPrefix() + ": Checking exist for [" + filename + "]: " + request.toString()));
            HttpResponse<Void> response = HttpClients.getHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
            int statusCode = response.statusCode();
            Msg.debug((Object)this, (Object)(this.logPrefix() + ": Response: " + response.statusCode()));
            return statusCode == 200;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    @Override
    public SymbolServerInputStream getFileStream(String filename, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setIndeterminate(true);
        monitor.setMessage("Connecting to " + String.valueOf(this.serverURI));
        HttpRequest request = this.request(filename).GET().build();
        Msg.debug((Object)this, (Object)(this.logPrefix() + ": Getting file [" + filename + "]: " + request.toString()));
        CompletableFuture<HttpResponse<InputStream>> futureResponse = HttpClients.getHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofInputStream());
        CancelledListener l = () -> futureResponse.cancel(true);
        monitor.addCancelledListener(l);
        try {
            HttpResponse<InputStream> response = futureResponse.get(10000L, TimeUnit.MILLISECONDS);
            int statusCode = response.statusCode();
            monitor.setMessage(statusCode == 200 ? "Success" : "Failed");
            Msg.debug((Object)this, (Object)(this.logPrefix() + ": Http response: " + response.statusCode()));
            InputStream bodyIS = response.body();
            if (statusCode != 200) {
                HttpSymbolServer.uncheckedClose(bodyIS);
                throw new IOException("Unable to get file: " + statusCode);
            }
            long contentLen = response.headers().firstValueAsLong("Content-Length").orElse(-1L);
            SymbolServerInputStream symbolServerInputStream = new SymbolServerInputStream(bodyIS, contentLen);
            return symbolServerInputStream;
        }
        catch (InterruptedException e) {
            throw new CancelledException("Download canceled");
        }
        catch (TimeoutException e) {
            throw new IOException("Connection timed out");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Msg.error((Object)this, (Object)"Error during HTTP get", (Throwable)cause);
            throw cause instanceof IOException ? (IOException)cause : new IOException("Error during HTTP get", cause);
        }
        finally {
            monitor.removeCancelledListener(l);
        }
    }

    @Override
    public String getFileLocation(String filename) {
        return this.serverURI.resolve(filename).toString();
    }

    @Override
    public boolean isTrusted() {
        return this.trusted;
    }

    @Override
    public void setTrusted(boolean isTrusted) {
        this.trusted = isTrusted;
    }

    public String toString() {
        return String.format("HttpSymbolServer: [ url: %s, trusted: %b, storageLevel: %d]", this.serverURI.toString(), this.trusted, this.storageLevel);
    }

    private String logPrefix() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.serverURI) + "]";
    }

    private static void uncheckedClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

