/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.graph.visualization.GraphRenderer;
import ghidra.graph.visualization.LayoutFunction;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.algorithms.BalloonLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.util.LayoutAlgorithmTransition;
import org.jungrapht.visualization.util.LayoutPaintable;

class LayoutTransitionManager {
    LayoutFunction layoutFunction;
    VisualizationServer<AttributedVertex, AttributedEdge> visualizationServer;
    Predicate<AttributedVertex> rootPredicate;
    Function<AttributedVertex, Rectangle> vertexBoundsFunction;
    RenderContext<AttributedVertex, AttributedEdge> renderContext;
    LayoutPaintable.BalloonRings<AttributedVertex, AttributedEdge> balloonLayoutRings;
    LayoutPaintable.RadialRings<AttributedVertex> radialLayoutRings;

    public LayoutTransitionManager(VisualizationServer<AttributedVertex, AttributedEdge> visualizationServer, Predicate<AttributedVertex> rootPredicate, GraphRenderer renderer) {
        this.visualizationServer = visualizationServer;
        this.rootPredicate = rootPredicate;
        this.renderContext = visualizationServer.getRenderContext();
        this.vertexBoundsFunction = visualizationServer.getRenderContext().getVertexBoundsFunction();
        this.layoutFunction = new LayoutFunction(renderer);
    }

    public void setLayout(String layoutName) {
        LayoutAlgorithm.Builder<AttributedVertex, ?, ?> builder = this.layoutFunction.apply(layoutName);
        LayoutAlgorithm layoutAlgorithm = builder.build();
        if (layoutAlgorithm instanceof VertexBoundsFunctionConsumer) {
            ((VertexBoundsFunctionConsumer)layoutAlgorithm).setVertexBoundsFunction(this.vertexBoundsFunction);
        }
        if (layoutAlgorithm instanceof Layered) {
            ((Layered)layoutAlgorithm).setMaxLevelCrossFunction(g -> Math.max(1, Math.min(10, 500 / g.vertexSet().size())));
        }
        if (layoutAlgorithm instanceof TreeLayout) {
            ((TreeLayout)layoutAlgorithm).setRootPredicate(this.rootPredicate);
        }
        this.removePaintable((VisualizationServer.Paintable)this.radialLayoutRings);
        this.removePaintable((VisualizationServer.Paintable)this.balloonLayoutRings);
        if (layoutAlgorithm instanceof BalloonLayoutAlgorithm) {
            this.balloonLayoutRings = new LayoutPaintable.BalloonRings(this.visualizationServer, (BalloonLayoutAlgorithm)layoutAlgorithm);
            this.visualizationServer.addPreRenderPaintable(this.balloonLayoutRings);
        }
        if (layoutAlgorithm instanceof RadialTreeLayout) {
            this.radialLayoutRings = new LayoutPaintable.RadialRings(this.visualizationServer, (RadialTreeLayout)layoutAlgorithm);
            this.visualizationServer.addPreRenderPaintable(this.radialLayoutRings);
        }
        LayoutAlgorithmTransition.apply(this.visualizationServer, (LayoutAlgorithm)layoutAlgorithm);
    }

    private void removePaintable(VisualizationServer.Paintable paintable) {
        if (paintable != null) {
            this.visualizationServer.removePreRenderPaintable(paintable);
        }
    }

    public LayoutAlgorithm<AttributedVertex> getInitialLayoutAlgorithm() {
        LayoutAlgorithm initialLayoutAlgorithm = this.layoutFunction.apply("Compact Hierarchical").build();
        if (initialLayoutAlgorithm instanceof TreeLayout) {
            ((TreeLayout)initialLayoutAlgorithm).setRootPredicate(this.rootPredicate);
        }
        if (initialLayoutAlgorithm instanceof VertexBoundsFunctionConsumer) {
            ((VertexBoundsFunctionConsumer)initialLayoutAlgorithm).setVertexBoundsFunction(this.vertexBoundsFunction);
        }
        return initialLayoutAlgorithm;
    }
}

