/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDBasicName;
import mdemangler.naming.MDQualifiedName;

public class MDBasedAttribute
extends MDParsableItem {
    private static final String prefixEmitClauseBased = "__based(";
    private static final String suffixEmitClauseBased = ")";
    private String basedName;
    boolean basedPtrBased;
    boolean parsed = false;

    public MDBasedAttribute(MDMang dmang) {
        super(dmang);
    }

    public boolean isBasedPtrBased() {
        return this.basedPtrBased;
    }

    @Override
    protected void parseInternal() throws MDException {
        block19: {
            block18: {
                boolean boolean32BitSymbols;
                this.parsed = true;
                boolean bl = boolean32BitSymbols = this.dmang.getArchitectureSize() != 16;
                if (!boolean32BitSymbols) break block18;
                switch (this.dmang.getAndIncrement()) {
                    case '0': {
                        this.basedName = "void";
                        break block19;
                    }
                    case '2': {
                        MDQualifiedName qn = new MDQualifiedName(this.dmang);
                        qn.parse();
                        StringBuilder qnBuilder = new StringBuilder();
                        qn.insert(qnBuilder);
                        this.basedName = qnBuilder.toString();
                        break block19;
                    }
                    case '5': {
                        this.basedPtrBased = true;
                        this.basedName = null;
                        break block19;
                    }
                    case '\uffff': {
                        throw new MDException("Missing based value.");
                    }
                    default: {
                        this.basedName = "";
                        return;
                    }
                }
            }
            switch (this.dmang.getAndIncrement()) {
                case '0': {
                    this.basedName = "void";
                    break;
                }
                case '1': {
                    this.basedName = "__self";
                    break;
                }
                case '2': {
                    this.basedName = "NYI:__near*";
                    break;
                }
                case '3': {
                    this.basedName = "NYI:__far*";
                    break;
                }
                case '4': {
                    this.basedName = "NYI:__huge*";
                    break;
                }
                case '5': {
                    this.basedPtrBased = true;
                    this.basedName = null;
                    break;
                }
                case '6': {
                    this.basedName = "NYI:__segment";
                    break;
                }
                case '7': {
                    MDBasicName bn = new MDBasicName(this.dmang);
                    bn.parse();
                    StringBuilder bnBuilder = new StringBuilder();
                    bn.insert(bnBuilder);
                    this.dmang.appendString(bnBuilder, "\")");
                    this.dmang.insertString(bnBuilder, "__segmname(\"");
                    this.basedName = bnBuilder.toString();
                    break;
                }
                case '8': {
                    this.basedName = "NYI:<segment-address-of-variable>";
                    break;
                }
                case '\uffff': {
                    throw new MDException("Missing based value.");
                }
                default: {
                    this.basedName = "";
                    return;
                }
            }
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (!this.parsed) {
            return;
        }
        if (this.basedPtrBased) {
            builder.setLength(0);
            builder.append('\u0000');
            return;
        }
        this.dmang.insertSpacedString(builder, suffixEmitClauseBased);
        this.dmang.insertString(builder, this.basedName);
        this.dmang.insertString(builder, prefixEmitClauseBased);
    }

    @Override
    public void append(StringBuilder builder) {
        if (!this.parsed) {
            return;
        }
        if (this.basedPtrBased) {
            builder.setLength(0);
            builder.append('\u0000');
            return;
        }
        this.dmang.appendString(builder, " ");
        this.dmang.appendString(builder, prefixEmitClauseBased);
        this.dmang.appendString(builder, this.basedName);
        this.dmang.appendString(builder, suffixEmitClauseBased);
    }
}

