/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.Token;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TokenListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_TOKEN_LIST";
    private int tokenListSize;
    private int tokenListEntries;
    private int listHeaderSize;
    private int elementHeaderSize;
    private Token[] tokens;
    private DumpFileReader reader;
    private long index;

    TokenListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setTokenListSize(this.reader.readNextInt());
        this.setTokenListEntries(this.reader.readNextInt());
        this.setListHeaderSize(this.reader.readNextInt());
        this.setElementHeaderSize(this.reader.readNextInt());
        this.tokens = new Token[this.getTokenListEntries()];
        for (int i = 0; i < this.getTokenListEntries(); ++i) {
            this.setToken(new Token(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "TokenListSize", null);
        struct.add(DWORD, 4, "TokenListEntries", null);
        struct.add(DWORD, 4, "ListHeaderSize", null);
        struct.add(DWORD, 4, "ElementHeaderSize", null);
        DataType t = this.tokens[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.getTokenListEntries(), t.getLength());
        struct.add((DataType)a, a.getLength(), "Tokens", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public Token getToken(int idx) {
        return this.tokens[idx];
    }

    public void setToken(Token token, int index) {
        this.tokens[index] = token;
    }

    public int getTokenListSize() {
        return this.tokenListSize;
    }

    public void setTokenListSize(int tokenListSize) {
        this.tokenListSize = tokenListSize;
    }

    public int getTokenListEntries() {
        return this.tokenListEntries;
    }

    public void setTokenListEntries(int tokenListEntries) {
        this.tokenListEntries = tokenListEntries;
    }

    public int getListHeaderSize() {
        return this.listHeaderSize;
    }

    public void setListHeaderSize(int listHeaderSize) {
        this.listHeaderSize = listHeaderSize;
    }

    public int getElementHeaderSize() {
        return this.elementHeaderSize;
    }

    public void setElementHeaderSize(int elementHeaderSize) {
        this.elementHeaderSize = elementHeaderSize;
    }
}

