/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.formatting.FormattingMode;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.ChangedRangesInfo;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.DocCommentSettings;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.Indent;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public abstract class CodeStyleManager {
    public static CodeStyleManager getInstance(@NotNull Project project) {
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(0);
        }
        return project.getService(CodeStyleManager.class);
    }

    public static CodeStyleManager getInstance(@NotNull PsiManager manager) {
        if (manager == null) {
            CodeStyleManager.$$$reportNull$$$0(1);
        }
        return CodeStyleManager.getInstance(manager.getProject());
    }

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    public abstract PsiElement reformat(@NotNull PsiElement var1, boolean var2) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract PsiElement reformatRange(@NotNull PsiElement var1, int var2, int var3, boolean var4) throws IncorrectOperationException;

    public abstract void reformatText(@NotNull PsiFile var1, int var2, int var3) throws IncorrectOperationException;

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<? extends TextRange> ranges, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            CodeStyleManager.$$$reportNull$$$0(3);
        }
        this.reformatText(file, ranges);
    }

    public abstract void reformatText(@NotNull PsiFile var1, @NotNull Collection<? extends TextRange> var2) throws IncorrectOperationException;

    @Deprecated
    public void reformatTextWithContext(@NotNull PsiFile file, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(4);
        }
        if (info == null) {
            CodeStyleManager.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException("Deprecated method");
    }

    public void reformatChanges(@NotNull PsiFile file, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(6);
        }
        if (info == null) {
            CodeStyleManager.$$$reportNull$$$0(7);
        }
        this.reformatTextWithContext(file, info);
    }

    @Deprecated
    public void reformatTextWithContext(@NotNull PsiFile file, @NotNull Collection<? extends TextRange> ranges) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(8);
        }
        if (ranges == null) {
            CodeStyleManager.$$$reportNull$$$0(9);
        }
        ArrayList<TextRange> rangesList = new ArrayList<TextRange>(ranges);
        this.reformatChanges(file, new ChangedRangesInfo(rangesList, null));
    }

    public abstract void adjustLineIndent(@NotNull PsiFile var1, TextRange var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull PsiFile var1, int var2) throws IncorrectOperationException;

    public abstract int adjustLineIndent(@NotNull Document var1, int var2);

    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManager.$$$reportNull$$$0(10);
        }
    }

    @Deprecated
    public abstract boolean isLineToBeIndented(@NotNull PsiFile var1, int var2);

    @Nullable
    public abstract String getLineIndent(@NotNull PsiFile var1, int var2);

    @Nullable
    public List<String> getLineIndents(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset, FormattingMode mode) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(12);
        }
        return this.getLineIndent(file, offset);
    }

    @Nullable
    public abstract String getLineIndent(@NotNull Document var1, int var2);

    @Deprecated
    public abstract Indent getIndent(String var1, FileType var2);

    @Deprecated
    public abstract String fillIndent(Indent var1, FileType var2);

    @Deprecated
    public abstract Indent zeroIndent();

    public abstract void reformatNewlyAddedElement(@NotNull ASTNode var1, @NotNull ASTNode var2) throws IncorrectOperationException;

    public abstract boolean isSequentialProcessingAllowed();

    public abstract void performActionWithFormatterDisabled(Runnable var1);

    public abstract <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> var1) throws T;

    public abstract <T> T performActionWithFormatterDisabled(Computable<T> var1);

    public int getSpacing(@NotNull PsiFile file, int offset) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(13);
        }
        return -1;
    }

    public int getMinLineFeeds(@NotNull PsiFile file, int offset) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(14);
        }
        return -1;
    }

    public static FormattingMode getCurrentFormattingMode(@NotNull Project project) {
        CodeStyleManager instance2;
        if (project == null) {
            CodeStyleManager.$$$reportNull$$$0(15);
        }
        if (!project.isDisposed() && (instance2 = CodeStyleManager.getInstance(project)) instanceof FormattingModeAwareIndentAdjuster) {
            return ((FormattingModeAwareIndentAdjuster)((Object)instance2)).getCurrentFormattingMode();
        }
        return FormattingMode.REFORMAT;
    }

    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file, @NotNull Runnable runnable) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(16);
        }
        if (runnable == null) {
            CodeStyleManager.$$$reportNull$$$0(17);
        }
        runnable.run();
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(18);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManager.$$$reportNull$$$0(19);
        }
        return docCommentSettings;
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManager.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/CodeStyleManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformatChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndents";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentFormattingMode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReformatWhenSettingsComputed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public static final Topic<Listener> TOPIC = new Topic<Listener>(Listener.class, Topic.BroadcastDirection.NONE, true);

        public void beforeReformatText(@NotNull PsiFile var1);

        public void afterReformatText(@NotNull PsiFile var1);
    }
}

