/*istanbul ignore start*/
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parsePatch = parsePatch;

/*istanbul ignore end*/
function parsePatch(uniDiff) {
  /*istanbul ignore start*/
  var
  /*istanbul ignore end*/
  options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var diffstr = uniDiff.split(/\r\n|[\n\v\f\r\x85]/),
      delimiters = uniDiff.match(/\r\n|[\n\v\f\r\x85]/g) || [],
      list = [],
      i = 0;

  function parseIndex() {
    var index = {};
    list.push(index); // Parse diff metadata

    while (i < diffstr.length) {
      var line = diffstr[i]; // File header found, end parsing diff metadata

      if (/^(\-\-\-|\+\+\+|@@)\s/.test(line)) {
        break;
      } // Diff index


      var headerMatch = /^(?:Index:|diff(?: -r \w+)+)\s+/.exec(line);

      if (headerMatch) {
        index.index = line.substring(headerMatch[0].length).trim();
      }

      i++;
    } // Parse file headers if they are defined. Unified diff requires them, but
    // there's no technical issues to have an isolated hunk without file header


    parseFileHeader(index);
    parseFileHeader(index); // Parse hunks

    index.hunks = [];

    while (i < diffstr.length) {
      var _line = diffstr[i];

      if (/^(Index:|diff|\-\-\-|\+\+\+)\s/.test(_line)) {
        break;
      } else if (/^@@/.test(_line)) {
        index.hunks.push(parseHunk());
      } else if (_line && options.strict) {
        // Ignore unexpected content unless in strict mode
        throw new Error('Unknown line ' + (i + 1) + ' ' + JSON.stringify(_line));
      } else {
        i++;
      }
    }
  } // Parses the --- and +++ headers, if none are found, no lines
  // are consumed.


  function parseFileHeader(index) {
    var fileHeaderMatch = /^(---|\+\+\+)\s+/.exec(diffstr[i]);

    if (fileHeaderMatch) {
      var keyPrefix = fileHeaderMatch[1] === '---' ? 'old' : 'new';
      var data = diffstr[i].substring(3).trim().split('\t', 2);
      var fileName = data[0].replace(/\\\\/g, '\\');

      if (fileName.startsWith('"') && fileName.endsWith('"')) {
        fileName = fileName.substr(1, fileName.length - 2);
      }

      index[keyPrefix + 'FileName'] = fileName;
      index[keyPrefix + 'Header'] = (data[1] || '').trim();
      i++;
    }
  } // Parses a hunk
  // This assumes that we are at the start of a hunk.


  function parseHunk() {
    var chunkHeaderIndex = i,
        chunkHeaderLine = diffstr[i++],
        chunkHeader = chunkHeaderLine.split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/);
    var hunk = {
      oldStart: +chunkHeader[1],
      oldLines: typeof chunkHeader[2] === 'undefined' ? 1 : +chunkHeader[2],
      newStart: +chunkHeader[3],
      newLines: typeof chunkHeader[4] === 'undefined' ? 1 : +chunkHeader[4],
      lines: [],
      linedelimiters: []
    }; // Unified Diff Format quirk: If the chunk size is 0,
    // the first number is one lower than one would expect.
    // https://www.artima.com/weblogs/viewpost.jsp?thread=164293

    if (hunk.oldLines === 0) {
      hunk.oldStart += 1;
    }

    if (hunk.newLines === 0) {
      hunk.newStart += 1;
    }

    var addCount = 0,
        removeCount = 0;

    for (; i < diffstr.length; i++) {
      // Lines starting with '---' could be mistaken for the "remove line" operation
      // But they could be the header for the next file. Therefore prune such cases out.
      if (diffstr[i].indexOf('--- ') === 0 && i + 2 < diffstr.length && diffstr[i + 1].indexOf('+++ ') === 0 && diffstr[i + 2].indexOf('@@') === 0) {
        break;
      }

      var operation = diffstr[i].length == 0 && i != diffstr.length - 1 ? ' ' : diffstr[i][0];

      if (operation === '+' || operation === '-' || operation === ' ' || operation === '\\') {
        hunk.lines.push(diffstr[i]);
        hunk.linedelimiters.push(delimiters[i] || '\n');

        if (operation === '+') {
          addCount++;
        } else if (operation === '-') {
          removeCount++;
        } else if (operation === ' ') {
          addCount++;
          removeCount++;
        }
      } else {
        break;
      }
    } // Handle the empty block count case


    if (!addCount && hunk.newLines === 1) {
      hunk.newLines = 0;
    }

    if (!removeCount && hunk.oldLines === 1) {
      hunk.oldLines = 0;
    } // Perform optional sanity checking


    if (options.strict) {
      if (addCount !== hunk.newLines) {
        throw new Error('Added line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
      }

      if (removeCount !== hunk.oldLines) {
        throw new Error('Removed line count did not match for hunk at line ' + (chunkHeaderIndex + 1));
      }
    }

    return hunk;
  }

  while (i < diffstr.length) {
    parseIndex();
  }

  return list;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
