/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ASdebug.ASDebugStream;
import antlr.ASdebug.IASDebugStream;
import antlr.ASdebug.TokenOffsetInfo;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenWithIndex;
import antlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenStreamRewriteEngine
implements TokenStream,
IASDebugStream {
    public static final int MIN_TOKEN_INDEX = 0;
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    protected List tokens;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;
    protected int index = 0;
    protected TokenStream stream;
    protected BitSet discardMask = new BitSet();

    public TokenStreamRewriteEngine(TokenStream tokenStream) {
        this(tokenStream, 1000);
    }

    public TokenStreamRewriteEngine(TokenStream tokenStream, int n15) {
        this.stream = tokenStream;
        this.tokens = new ArrayList(n15);
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public Token nextToken() throws TokenStreamException {
        TokenWithIndex tokenWithIndex;
        do {
            if ((tokenWithIndex = (TokenWithIndex)this.stream.nextToken()) == null) continue;
            tokenWithIndex.setIndex(this.index);
            if (tokenWithIndex.getType() != 1) {
                this.tokens.add(tokenWithIndex);
            }
            ++this.index;
        } while (tokenWithIndex != null && this.discardMask.member(tokenWithIndex.getType()));
        return tokenWithIndex;
    }

    public void rollback(int n15) {
        this.rollback(DEFAULT_PROGRAM_NAME, n15);
    }

    public void rollback(String string, int n15) {
        List list2 = (List)this.programs.get(string);
        if (list2 != null) {
            this.programs.put(string, list2.subList(0, n15));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String string) {
        this.rollback(string, 0);
    }

    protected void addToSortedRewriteList(RewriteOperation rewriteOperation) {
        this.addToSortedRewriteList(DEFAULT_PROGRAM_NAME, rewriteOperation);
    }

    protected void addToSortedRewriteList(String string, RewriteOperation rewriteOperation) {
        Comparator comparator;
        List list2 = this.getProgram(string);
        int n15 = Collections.binarySearch(list2, rewriteOperation, comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                RewriteOperation rewriteOperation = (RewriteOperation)object;
                RewriteOperation rewriteOperation2 = (RewriteOperation)object2;
                if (rewriteOperation.index < rewriteOperation2.index) {
                    return -1;
                }
                if (rewriteOperation.index > rewriteOperation2.index) {
                    return 1;
                }
                return 0;
            }
        });
        if (n15 >= 0) {
            while (n15 >= 0) {
                RewriteOperation rewriteOperation2 = (RewriteOperation)list2.get(n15);
                if (rewriteOperation2.index < rewriteOperation.index) break;
                --n15;
            }
            ++n15;
            if (rewriteOperation instanceof ReplaceOp) {
                int n16;
                boolean bl4 = false;
                for (n16 = n15; n16 < list2.size(); ++n16) {
                    RewriteOperation rewriteOperation3 = (RewriteOperation)list2.get(n15);
                    if (rewriteOperation3.index != rewriteOperation.index) break;
                    if (!(rewriteOperation3 instanceof ReplaceOp)) continue;
                    list2.set(n15, rewriteOperation);
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    list2.add(n16, rewriteOperation);
                }
            } else {
                list2.add(n15, rewriteOperation);
            }
        } else {
            list2.add(-n15 - 1, rewriteOperation);
        }
    }

    public void insertAfter(Token token, String string) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, token, string);
    }

    public void insertAfter(int n15, String string) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, n15, string);
    }

    public void insertAfter(String string, Token token, String string2) {
        this.insertAfter(string, ((TokenWithIndex)token).getIndex(), string2);
    }

    public void insertAfter(String string, int n15, String string2) {
        this.insertBefore(string, n15 + 1, string2);
    }

    public void insertBefore(Token token, String string) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, token, string);
    }

    public void insertBefore(int n15, String string) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, n15, string);
    }

    public void insertBefore(String string, Token token, String string2) {
        this.insertBefore(string, ((TokenWithIndex)token).getIndex(), string2);
    }

    public void insertBefore(String string, int n15, String string2) {
        this.addToSortedRewriteList(string, new InsertBeforeOp(n15, string2));
    }

    public void replace(int n15, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, n15, n15, string);
    }

    public void replace(int n15, int n16, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, n15, n16, string);
    }

    public void replace(Token token, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token, string);
    }

    public void replace(Token token, Token token2, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token2, string);
    }

    public void replace(String string, int n15, int n16, String string2) {
        this.addToSortedRewriteList(new ReplaceOp(n15, n16, string2));
    }

    public void replace(String string, Token token, Token token2, String string2) {
        this.replace(string, ((TokenWithIndex)token).getIndex(), ((TokenWithIndex)token2).getIndex(), string2);
    }

    public void delete(int n15) {
        this.delete(DEFAULT_PROGRAM_NAME, n15, n15);
    }

    public void delete(int n15, int n16) {
        this.delete(DEFAULT_PROGRAM_NAME, n15, n16);
    }

    public void delete(Token token) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token);
    }

    public void delete(Token token, Token token2) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token2);
    }

    public void delete(String string, int n15, int n16) {
        this.replace(string, n15, n16, null);
    }

    public void delete(String string, Token token, Token token2) {
        this.replace(string, token, token2, null);
    }

    public void discard(int n15) {
        this.discardMask.add(n15);
    }

    public TokenWithIndex getToken(int n15) {
        return (TokenWithIndex)this.tokens.get(n15);
    }

    public int getTokenStreamSize() {
        return this.tokens.size();
    }

    public String toOriginalString() {
        return this.toOriginalString(0, this.getTokenStreamSize() - 1);
    }

    public String toOriginalString(int n15, int n16) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i15 = n15; i15 >= 0 && i15 <= n16 && i15 < this.tokens.size(); ++i15) {
            stringBuffer.append(this.getToken(i15).getText());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0, this.getTokenStreamSize() - 1);
    }

    public String toString(String string) {
        return this.toString(string, 0, this.getTokenStreamSize() - 1);
    }

    public String toString(int n15, int n16) {
        return this.toString(DEFAULT_PROGRAM_NAME, n15, n16);
    }

    public String toString(String string, int n15, int n16) {
        List list2 = (List)this.programs.get(string);
        if (list2 == null || list2.size() == 0) {
            return this.toOriginalString(n15, n16);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n17 = 0;
        int n18 = n15;
        while (n18 >= 0 && n18 <= n16 && n18 < this.tokens.size()) {
            if (n17 < list2.size()) {
                RewriteOperation rewriteOperation = (RewriteOperation)list2.get(n17);
                while (rewriteOperation.index < n18 && n17 < list2.size()) {
                    if (++n17 >= list2.size()) continue;
                    rewriteOperation = (RewriteOperation)list2.get(n17);
                }
                while (n18 == rewriteOperation.index && n17 < list2.size()) {
                    n18 = rewriteOperation.execute(stringBuffer);
                    if (++n17 >= list2.size()) continue;
                    rewriteOperation = (RewriteOperation)list2.get(n17);
                }
            }
            if (n18 > n16) continue;
            stringBuffer.append(this.getToken(n18).getText());
            ++n18;
        }
        for (int i15 = n17; i15 < list2.size(); ++i15) {
            RewriteOperation rewriteOperation = (RewriteOperation)list2.get(i15);
            if (rewriteOperation.index < this.size()) continue;
            rewriteOperation.execute(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        return this.toDebugString(0, this.getTokenStreamSize() - 1);
    }

    public String toDebugString(int n15, int n16) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i15 = n15; i15 >= 0 && i15 <= n16 && i15 < this.tokens.size(); ++i15) {
            stringBuffer.append(this.getToken(i15));
        }
        return stringBuffer.toString();
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String string) {
        Integer n15 = (Integer)this.lastRewriteTokenIndexes.get(string);
        if (n15 == null) {
            return -1;
        }
        return n15;
    }

    protected void setLastRewriteTokenIndex(String string, int n15) {
        this.lastRewriteTokenIndexes.put(string, new Integer(n15));
    }

    protected List getProgram(String string) {
        List list2 = (List)this.programs.get(string);
        if (list2 == null) {
            list2 = this.initializeProgram(string);
        }
        return list2;
    }

    private List initializeProgram(String string) {
        ArrayList arrayList = new ArrayList(100);
        this.programs.put(string, arrayList);
        return arrayList;
    }

    public int size() {
        return this.tokens.size();
    }

    public int index() {
        return this.index;
    }

    public String getEntireText() {
        return ASDebugStream.getEntireText(this.stream);
    }

    public TokenOffsetInfo getOffsetInfo(Token token) {
        return ASDebugStream.getOffsetInfo(this.stream, token);
    }

    static class DeleteOp
    extends ReplaceOp {
        public DeleteOp(int n15, int n16) {
            super(n15, n16, null);
        }
    }

    static class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int n15, int n16, String string) {
            super(n15, string);
            this.lastIndex = n16;
        }

        public int execute(StringBuffer stringBuffer) {
            if (this.text != null) {
                stringBuffer.append(this.text);
            }
            return this.lastIndex + 1;
        }
    }

    static class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int n15, String string) {
            super(n15, string);
        }

        public int execute(StringBuffer stringBuffer) {
            stringBuffer.append(this.text);
            return this.index;
        }
    }

    static class RewriteOperation {
        protected int index;
        protected String text;

        protected RewriteOperation(int n15, String string) {
            this.index = n15;
            this.text = string;
        }

        public int execute(StringBuffer stringBuffer) {
            return this.index;
        }

        public String toString() {
            String string = this.getClass().getName();
            int n15 = string.indexOf(36);
            string = string.substring(n15 + 1, string.length());
            return string + "@" + this.index + '\"' + this.text + '\"';
        }
    }
}

