/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;

public class IntegerTokenConverter
extends DynamicConverter<Object>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "i";

    @Override
    public String convert(int i15) {
        String s15 = Integer.toString(i15);
        FormatInfo formattingInfo = this.getFormattingInfo();
        if (formattingInfo == null) {
            return s15;
        }
        int min = formattingInfo.getMin();
        StringBuilder sbuf = new StringBuilder();
        for (int j15 = s15.length(); j15 < min; ++j15) {
            sbuf.append('0');
        }
        return sbuf.append(s15).toString();
    }

    @Override
    public String convert(Object o15) {
        if (o15 == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o15 instanceof Integer) {
            Integer i15 = (Integer)o15;
            return this.convert(i15);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(o15) + " of type" + o15.getClass().getName());
    }

    @Override
    public boolean isApplicable(Object o15) {
        return o15 instanceof Integer;
    }
}

