/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import com.android.apksig.zip.ZipSections;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ApkUtilsLite {
    private static final long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static final int APK_SIG_BLOCK_MIN_SIZE = 32;

    private ApkUtilsLite() {
    }

    public static ZipSections findZipSections(DataSource apk) throws IOException, ZipFormatException {
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = ZipUtils.findZipEndOfCentralDirectoryRecord(apk);
        if (eocdAndOffsetInFile == null) {
            throw new ZipFormatException("ZIP End of Central Directory record not found");
        }
        ByteBuffer eocdBuf = eocdAndOffsetInFile.getFirst();
        long eocdOffset = eocdAndOffsetInFile.getSecond();
        eocdBuf.order(ByteOrder.LITTLE_ENDIAN);
        long cdStartOffset = ZipUtils.getZipEocdCentralDirectoryOffset(eocdBuf);
        if (cdStartOffset > eocdOffset) {
            throw new ZipFormatException("ZIP Central Directory start offset out of range: " + cdStartOffset + ". ZIP End of Central Directory offset: " + eocdOffset);
        }
        long cdSizeBytes = ZipUtils.getZipEocdCentralDirectorySizeBytes(eocdBuf);
        long cdEndOffset = cdStartOffset + cdSizeBytes;
        if (cdEndOffset > eocdOffset) {
            throw new ZipFormatException("ZIP Central Directory overlaps with End of Central Directory. CD end: " + cdEndOffset + ", EoCD start: " + eocdOffset);
        }
        int cdRecordCount = ZipUtils.getZipEocdCentralDirectoryTotalRecordCount(eocdBuf);
        return new ZipSections(cdStartOffset, cdSizeBytes, cdRecordCount, eocdOffset, eocdBuf);
    }

    public static ApkSigningBlock findApkSigningBlock(DataSource apk, ZipSections zipSections) throws IOException, ApkSigningBlockNotFoundException {
        long eocdStartOffset;
        long centralDirStartOffset = zipSections.getZipCentralDirectoryOffset();
        long centralDirEndOffset = centralDirStartOffset + zipSections.getZipCentralDirectorySizeBytes();
        if (centralDirEndOffset != (eocdStartOffset = zipSections.getZipEndOfCentralDirectoryOffset())) {
            throw new ApkSigningBlockNotFoundException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + centralDirEndOffset + ", EoCD start: " + eocdStartOffset);
        }
        if (centralDirStartOffset < 32L) {
            throw new ApkSigningBlockNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + centralDirStartOffset);
        }
        ByteBuffer footer = apk.getByteBuffer(centralDirStartOffset - 24L, 24);
        footer.order(ByteOrder.LITTLE_ENDIAN);
        if (footer.getLong(8) != 2334950737559900225L || footer.getLong(16) != 3617552046287187010L) {
            throw new ApkSigningBlockNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long apkSigBlockSizeInFooter = footer.getLong(0);
        if (apkSigBlockSizeInFooter < (long)footer.capacity() || apkSigBlockSizeInFooter > 0x7FFFFFF7L) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block size out of range: " + apkSigBlockSizeInFooter);
        }
        int totalSize = (int)(apkSigBlockSizeInFooter + 8L);
        long apkSigBlockOffset = centralDirStartOffset - (long)totalSize;
        if (apkSigBlockOffset < 0L) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block offset out of range: " + apkSigBlockOffset);
        }
        ByteBuffer apkSigBlock = apk.getByteBuffer(apkSigBlockOffset, 8);
        apkSigBlock.order(ByteOrder.LITTLE_ENDIAN);
        long apkSigBlockSizeInHeader = apkSigBlock.getLong(0);
        if (apkSigBlockSizeInHeader != apkSigBlockSizeInFooter) {
            throw new ApkSigningBlockNotFoundException("APK Signing Block sizes in header and footer do not match: " + apkSigBlockSizeInHeader + " vs " + apkSigBlockSizeInFooter);
        }
        return new ApkSigningBlock(apkSigBlockOffset, apk.slice(apkSigBlockOffset, totalSize));
    }

    public static byte[] computeSha256DigestBytes(byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e15) {
            throw new IllegalStateException("SHA-256 is not found", e15);
        }
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public static class ApkSigningBlock {
        private final long mStartOffsetInApk;
        private final DataSource mContents;

        public ApkSigningBlock(long startOffsetInApk, DataSource contents) {
            this.mStartOffsetInApk = startOffsetInApk;
            this.mContents = contents;
        }

        public long getStartOffset() {
            return this.mStartOffsetInApk;
        }

        public DataSource getContents() {
            return this.mContents;
        }
    }
}

