/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.annotool;

import com.android.dx.command.annotool.AnnotationLister;
import java.lang.annotation.ElementType;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Locale;

public class Main {
    private Main() {
    }

    public static void main(String[] argArray) {
        Arguments args = new Arguments();
        try {
            args.parse(argArray);
        }
        catch (InvalidArgumentException ex4) {
            System.err.println(ex4.getMessage());
            throw new RuntimeException("usage");
        }
        new AnnotationLister(args).process();
    }

    static class Arguments {
        String aclass;
        EnumSet<ElementType> eTypes = EnumSet.noneOf(ElementType.class);
        EnumSet<PrintType> printTypes = EnumSet.noneOf(PrintType.class);
        String[] files;

        Arguments() {
        }

        void parse(String[] argArray) throws InvalidArgumentException {
            for (int i15 = 0; i15 < argArray.length; ++i15) {
                String argParam;
                String arg = argArray[i15];
                if (arg.startsWith("--annotation=")) {
                    argParam = arg.substring(arg.indexOf(61) + 1);
                    if (this.aclass != null) {
                        throw new InvalidArgumentException("--annotation can only be specified once.");
                    }
                    this.aclass = argParam.replace('.', '/');
                    continue;
                }
                if (arg.startsWith("--element=")) {
                    argParam = arg.substring(arg.indexOf(61) + 1);
                    try {
                        for (String p15 : argParam.split(",")) {
                            this.eTypes.add(ElementType.valueOf(p15.toUpperCase(Locale.ROOT)));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException ex4) {
                        throw new InvalidArgumentException("invalid --element");
                    }
                }
                if (arg.startsWith("--print=")) {
                    argParam = arg.substring(arg.indexOf(61) + 1);
                    try {
                        for (String p15 : argParam.split(",")) {
                            this.printTypes.add(PrintType.valueOf(p15.toUpperCase(Locale.ROOT)));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException ex5) {
                        throw new InvalidArgumentException("invalid --print");
                    }
                }
                this.files = new String[argArray.length - i15];
                System.arraycopy(argArray, i15, this.files, 0, this.files.length);
                break;
            }
            if (this.aclass == null) {
                throw new InvalidArgumentException("--annotation must be specified");
            }
            if (this.printTypes.isEmpty()) {
                this.printTypes.add(PrintType.CLASS);
            }
            if (this.eTypes.isEmpty()) {
                this.eTypes.add(ElementType.TYPE);
            }
            Object set = this.eTypes.clone();
            ((AbstractCollection)set).remove((Object)ElementType.TYPE);
            ((AbstractCollection)set).remove((Object)ElementType.PACKAGE);
            if (!((AbstractCollection)set).isEmpty()) {
                throw new InvalidArgumentException("only --element parameters 'type' and 'package' supported");
            }
        }
    }

    private static class InvalidArgumentException
    extends Exception {
        InvalidArgumentException() {
        }

        InvalidArgumentException(String s15) {
            super(s15);
        }
    }

    static enum PrintType {
        CLASS,
        INNERCLASS,
        METHOD,
        PACKAGE;

    }
}

