/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2;

import com.android.tools.smali.util.ExceptionWithContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class MethodHandleType {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int INVOKE_STATIC = 4;
    public static final int INVOKE_INSTANCE = 5;
    public static final int INVOKE_CONSTRUCTOR = 6;
    public static final int INVOKE_DIRECT = 7;
    public static final int INVOKE_INTERFACE = 8;
    private static final Map<Integer, String> methodHandleTypeNames;
    private static final Map<String, Integer> inverse;

    private static Map<String, Integer> getInverse() {
        HashMap<String, Integer> namesToTypes = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : methodHandleTypeNames.entrySet()) {
            namesToTypes.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(namesToTypes);
    }

    @Nonnull
    public static String toString(int methodHandleType) {
        String val = methodHandleTypeNames.get(methodHandleType);
        if (val == null) {
            throw new InvalidMethodHandleTypeException(methodHandleType);
        }
        return val;
    }

    public static int getMethodHandleType(String methodHandleType) {
        Integer ret = inverse.get(methodHandleType);
        if (ret == null) {
            throw new ExceptionWithContext("Invalid method handle type: %s", methodHandleType);
        }
        return ret;
    }

    static {
        HashMap<Integer, String> temp = new HashMap<Integer, String>();
        temp.put(0, "static-put");
        temp.put(1, "static-get");
        temp.put(2, "instance-put");
        temp.put(3, "instance-get");
        temp.put(4, "invoke-static");
        temp.put(5, "invoke-instance");
        temp.put(6, "invoke-constructor");
        temp.put(7, "invoke-direct");
        temp.put(8, "invoke-interface");
        methodHandleTypeNames = Collections.unmodifiableMap(temp);
        inverse = MethodHandleType.getInverse();
    }

    public static class InvalidMethodHandleTypeException
    extends ExceptionWithContext {
        private final int methodHandleType;

        public InvalidMethodHandleTypeException(int methodHandleType) {
            super("Invalid method handle type: %d", methodHandleType);
            this.methodHandleType = methodHandleType;
        }

        public InvalidMethodHandleTypeException(int methodHandleType, String message2, Object ... formatArgs) {
            super(message2, formatArgs);
            this.methodHandleType = methodHandleType;
        }

        public int getMethodHandleType() {
            return this.methodHandleType;
        }
    }
}

