/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.analysis.AnalyzedInstruction;
import com.android.tools.smali.dexlib2.analysis.ClassPath;
import com.android.tools.smali.dexlib2.analysis.ClassProto;
import com.android.tools.smali.dexlib2.analysis.InlineMethodResolver;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.instruction.InlineIndexInstruction;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethod;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethodParameter;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.immutable.util.ParamUtil;
import com.android.tools.smali.util.InputStreamUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class CustomInlineMethodResolver
extends InlineMethodResolver {
    @Nonnull
    private final ClassPath classPath;
    @Nonnull
    private final Method[] inlineMethods;
    private static final Pattern longMethodPattern = Pattern.compile("(L[^;]+;)->([^(]+)\\(([^)]*)\\)(.+)");

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull String inlineTable) {
        this.classPath = classPath;
        StringReader reader = new StringReader(inlineTable);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br4 = new BufferedReader(reader);
        try {
            String line = br4.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = br4.readLine();
            }
        }
        catch (IOException ex4) {
            throw new RuntimeException("Error while parsing inline table", ex4);
        }
        this.inlineMethods = new Method[lines.size()];
        for (int i15 = 0; i15 < this.inlineMethods.length; ++i15) {
            this.inlineMethods[i15] = this.parseAndResolveInlineMethod((String)lines.get(i15));
        }
    }

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull File inlineTable) throws IOException {
        this(classPath, new String(InputStreamUtil.toByteArray(new FileInputStream(inlineTable)), StandardCharsets.UTF_8));
    }

    @Override
    @Nonnull
    public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
        InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
        int methodIndex = instruction.getInlineIndex();
        if (methodIndex < 0 || methodIndex >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid method index: " + methodIndex);
        }
        return this.inlineMethods[methodIndex];
    }

    @Nonnull
    private Method parseAndResolveInlineMethod(@Nonnull String inlineMethod) {
        Matcher m15 = longMethodPattern.matcher(inlineMethod);
        if (!m15.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + inlineMethod);
        }
        String className = m15.group(1);
        String methodName = m15.group(2);
        Iterable<ImmutableMethodParameter> methodParams = ParamUtil.parseParamString(m15.group(3));
        String methodRet = m15.group(4);
        ImmutableMethodReference methodRef = new ImmutableMethodReference(className, methodName, methodParams, methodRet);
        int accessFlags = 0;
        boolean resolved = false;
        TypeProto typeProto = this.classPath.getClass(className);
        if (typeProto instanceof ClassProto) {
            ClassDef classDef = ((ClassProto)typeProto).getClassDef();
            for (Method method : classDef.getMethods()) {
                if (!method.equals(methodRef)) continue;
                resolved = true;
                accessFlags = method.getAccessFlags();
                break;
            }
        }
        if (!resolved) {
            throw new RuntimeException("Cannot resolve inline method: " + inlineMethod);
        }
        return new ImmutableMethod(className, methodName, methodParams, methodRet, accessFlags, null, null, null);
    }
}

