/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.impl;

import com.github.weisj.jsvg.paint.SVGPaint;
import com.github.weisj.jsvg.paint.impl.PredefinedPaints;
import com.github.weisj.jsvg.renderer.impl.context.ContextElementAttributes;
import com.github.weisj.jsvg.renderer.impl.context.PaintContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaintResolver {
    private PaintResolver() {
    }

    @NotNull
    public static SVGPaint resolvePaint(@Nullable SVGPaint p15, @NotNull PaintContext paintContext, @Nullable ContextElementAttributes contextElementAttributes) {
        if (p15 == PredefinedPaints.DEFAULT_PAINT || p15 == PredefinedPaints.CURRENT_COLOR) {
            return PaintResolver.coerceNonNull(paintContext.color);
        }
        if (p15 == PredefinedPaints.CONTEXT_STROKE) {
            if (contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return contextElementAttributes.strokePaint;
        }
        if (p15 == PredefinedPaints.CONTEXT_FILL) {
            if (contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return contextElementAttributes.fillPaint;
        }
        return PaintResolver.coerceNonNull(p15);
    }

    @NotNull
    private static SVGPaint coerceNonNull(@Nullable SVGPaint p15) {
        return p15 != null ? p15 : PredefinedPaints.DEFAULT_PAINT;
    }
}

