/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.value.ConstantValue;
import com.github.weisj.jsvg.attributes.value.Value;
import com.github.weisj.jsvg.geometry.FillRuleAwareAWTSVGShape;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.geometry.path.BuildHistory;
import com.github.weisj.jsvg.geometry.path.PathCommand;
import com.github.weisj.jsvg.geometry.path.PathParser;
import java.awt.geom.Path2D;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtil {
    @Nullable
    private static final MethodHandle trimPathHandle = PathUtil.lookupTrimPathMethod();

    @Nullable
    private static MethodHandle lookupTrimPathMethod() {
        try {
            MethodType methodType = MethodType.methodType(Void.TYPE);
            return MethodHandles.lookup().findVirtual(Path2D.class, "trimToSize", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e15) {
            return null;
        }
    }

    private PathUtil() {
    }

    @NotNull
    public static SVGShape parseFromPathData(@NotNull String data, FillRule fillRule) {
        PathCommand[] pathCommands = new PathParser(data).parsePathCommand();
        int nodeCount = 2;
        for (PathCommand pathCommand : pathCommands) {
            nodeCount += pathCommand.nodeCount() - 1;
        }
        Path2D.Float path = new Path2D.Float(fillRule.awtWindingRule, nodeCount);
        BuildHistory hist = new BuildHistory();
        for (PathCommand pathCommand : pathCommands) {
            pathCommand.appendPath(path, hist);
        }
        PathUtil.trimPathToSize(path);
        return new FillRuleAwareAWTSVGShape((Value<Path2D>)new ConstantValue<Path2D>(path));
    }

    @NotNull
    public static Path2D setPolyLine(@Nullable Path2D path, float @NotNull [] points, boolean closed) {
        Path2D p15;
        if (path == null) {
            p15 = new Path2D.Float(0, points.length / 2);
        } else {
            p15 = path;
            p15.reset();
        }
        p15.moveTo(points[0], points[1]);
        for (int i15 = 2; i15 < points.length - 1; i15 += 2) {
            p15.lineTo(points[i15], points[i15 + 1]);
        }
        if (closed) {
            p15.closePath();
        }
        return p15;
    }

    public static void trimPathToSize(@NotNull Path2D path) {
        if (trimPathHandle != null) {
            try {
                trimPathHandle.invokeExact(path);
            }
            catch (Throwable e15) {
                throw new RuntimeException(e15);
            }
        }
    }
}

