/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.LittleEndianByteArray;

final class FarmHashFingerprint64
extends AbstractNonStreamingHashFunction {
    static final HashFunction FARMHASH_FINGERPRINT_64 = new FarmHashFingerprint64();
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;

    FarmHashFingerprint64() {
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        return HashCode.fromLong(FarmHashFingerprint64.fingerprint(input, off, len));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.farmHashFingerprint64()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes, int offset, int length) {
        if (length <= 32) {
            if (length <= 16) {
                return FarmHashFingerprint64.hashLength0to16(bytes, offset, length);
            }
            return FarmHashFingerprint64.hashLength17to32(bytes, offset, length);
        }
        if (length <= 64) {
            return FarmHashFingerprint64.hashLength33To64(bytes, offset, length);
        }
        return FarmHashFingerprint64.hashLength65Plus(bytes, offset, length);
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLength16(long u15, long v15, long mul) {
        long a15 = (u15 ^ v15) * mul;
        a15 ^= a15 >>> 47;
        long b15 = (v15 ^ a15) * mul;
        b15 ^= b15 >>> 47;
        return b15 *= mul;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes, int offset, long seedA, long seedB, long[] output) {
        long part1 = LittleEndianByteArray.load64(bytes, offset);
        long part2 = LittleEndianByteArray.load64(bytes, offset + 8);
        long part3 = LittleEndianByteArray.load64(bytes, offset + 16);
        long part4 = LittleEndianByteArray.load64(bytes, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 21);
        long c15 = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 44)) + c15;
    }

    private static long hashLength0to16(byte[] bytes, int offset, int length) {
        if (length >= 8) {
            long mul = -7286425919675154353L + (long)length * 2L;
            long a15 = LittleEndianByteArray.load64(bytes, offset) + -7286425919675154353L;
            long b15 = LittleEndianByteArray.load64(bytes, offset + length - 8);
            long c15 = Long.rotateRight(b15, 37) * mul + a15;
            long d15 = (Long.rotateRight(a15, 25) + b15) * mul;
            return FarmHashFingerprint64.hashLength16(c15, d15, mul);
        }
        if (length >= 4) {
            long mul = -7286425919675154353L + (long)(length * 2);
            long a16 = (long)LittleEndianByteArray.load32(bytes, offset) & 0xFFFFFFFFL;
            return FarmHashFingerprint64.hashLength16((long)length + (a16 << 3), (long)LittleEndianByteArray.load32(bytes, offset + length - 4) & 0xFFFFFFFFL, mul);
        }
        if (length > 0) {
            byte a17 = bytes[offset];
            byte b16 = bytes[offset + (length >> 1)];
            byte c16 = bytes[offset + (length - 1)];
            int y15 = (a17 & 0xFF) + ((b16 & 0xFF) << 8);
            int z15 = length + ((c16 & 0xFF) << 2);
            return FarmHashFingerprint64.shiftMix((long)y15 * -7286425919675154353L ^ (long)z15 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLength17to32(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)length * 2L;
        long a15 = LittleEndianByteArray.load64(bytes, offset) * -5435081209227447693L;
        long b15 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c15 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d15 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(a15 + b15, 43) + Long.rotateRight(c15, 30) + d15, a15 + Long.rotateRight(b15 + -7286425919675154353L, 18) + c15, mul);
    }

    private static long hashLength33To64(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)length * 2L;
        long a15 = LittleEndianByteArray.load64(bytes, offset) * -7286425919675154353L;
        long b15 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c15 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d15 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        long y15 = Long.rotateRight(a15 + b15, 43) + Long.rotateRight(c15, 30) + d15;
        long z15 = FarmHashFingerprint64.hashLength16(y15, a15 + Long.rotateRight(b15 + -7286425919675154353L, 18) + c15, mul);
        long e15 = LittleEndianByteArray.load64(bytes, offset + 16) * mul;
        long f15 = LittleEndianByteArray.load64(bytes, offset + 24);
        long g15 = (y15 + LittleEndianByteArray.load64(bytes, offset + length - 32)) * mul;
        long h15 = (z15 + LittleEndianByteArray.load64(bytes, offset + length - 24)) * mul;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(e15 + f15, 43) + Long.rotateRight(g15, 30) + h15, e15 + Long.rotateRight(f15 + a15, 18) + g15, mul);
    }

    private static long hashLength65Plus(byte[] bytes, int offset, int length) {
        int seed = 81;
        long x15 = seed;
        long y15 = (long)seed * -5435081209227447693L + 113L;
        long z15 = FarmHashFingerprint64.shiftMix(y15 * -7286425919675154353L + 113L) * -7286425919675154353L;
        long[] v15 = new long[2];
        long[] w15 = new long[2];
        x15 = x15 * -7286425919675154353L + LittleEndianByteArray.load64(bytes, offset);
        int end = offset + (length - 1) / 64 * 64;
        int last64offset = end + (length - 1 & 0x3F) - 63;
        do {
            x15 = Long.rotateRight(x15 + y15 + v15[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * -5435081209227447693L;
            y15 = Long.rotateRight(y15 + v15[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * -5435081209227447693L;
            z15 = Long.rotateRight(z15 + w15[0], 33) * -5435081209227447693L;
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v15[1] * -5435081209227447693L, (x15 ^= w15[1]) + w15[0], v15);
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z15 + w15[1], (y15 += v15[0] + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w15);
            long tmp = x15;
            x15 = z15;
            z15 = tmp;
        } while ((offset += 64) != end);
        long mul = -5435081209227447693L + ((z15 & 0xFFL) << 1);
        offset = last64offset;
        w15[0] = w15[0] + (long)(length - 1 & 0x3F);
        v15[0] = v15[0] + w15[0];
        w15[0] = w15[0] + v15[0];
        x15 = Long.rotateRight(x15 + y15 + v15[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * mul;
        y15 = Long.rotateRight(y15 + v15[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * mul;
        z15 = Long.rotateRight(z15 + w15[0], 33) * mul;
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v15[1] * mul, (x15 ^= w15[1] * 9L) + w15[0], v15);
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z15 + w15[1], (y15 += v15[0] * 9L + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w15);
        return FarmHashFingerprint64.hashLength16(FarmHashFingerprint64.hashLength16(v15[0], w15[0], mul) + FarmHashFingerprint64.shiftMix(y15) * -4348849565147123417L + x15, FarmHashFingerprint64.hashLength16(v15[1], w15[1], mul) + z15, mul);
    }
}

