/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.color.YCbCrConverter;
import com.twelvemonkeys.imageio.plugins.webp.vp8.BoolDecoder;
import com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import com.twelvemonkeys.imageio.plugins.webp.vp8.LoopFilter;
import com.twelvemonkeys.imageio.plugins.webp.vp8.MacroBlock;
import com.twelvemonkeys.imageio.plugins.webp.vp8.SegmentQuants;
import com.twelvemonkeys.imageio.plugins.webp.vp8.SubBlock;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.stream.ImageInputStream;

public final class VP8Frame {
    private static final int BLOCK_TYPES = 4;
    private static final int COEF_BANDS = 8;
    private static final int MAX_ENTROPY_TOKENS = 12;
    private static final int MAX_MODE_LF_DELTAS = 4;
    private static final int MAX_REF_LF_DELTAS = 4;
    private static final int PREV_COEF_CONTEXTS = 3;
    private IIOReadProgressListener listener = null;
    private final int[][][][] coefProbs;
    private int filterLevel;
    private final ImageInputStream frame;
    private final boolean debug;
    private int frameType;
    private int height;
    private int macroBlockCols;
    private int macroBlockNoCoeffSkip;
    private int macroBlockRows;
    private MacroBlock[][] macroBlocks;
    private int macroBlockSegementAbsoluteDelta;
    private int[] macroBlockSegmentTreeProbs;
    private final int[] modeLoopFilterDeltas = new int[4];
    private int modeRefLoopFilterDeltaEnabled;
    private int modeRefLoopFilterDeltaUpdate;
    private int multiTokenPartition = 0;
    private long offset;
    private final int[] refLoopFilterDeltas = new int[4];
    private int refreshEntropyProbs;
    private int refreshLastFrame;
    private int segmentationIsEnabled;
    private SegmentQuants segmentQuants;
    private int sharpnessLevel;
    private boolean simpleFilter;
    private BoolDecoder tokenBoolDecoder;
    private final List<BoolDecoder> tokenBoolDecoders;
    private int updateMacroBlockSegmentationMap;
    private int updateMacroBlockSegmentatonData;
    private int width;
    private final byte[] yuv = new byte[3];
    private final byte[] rgb = new byte[4];

    public VP8Frame(ImageInputStream imageInputStream, boolean bl4) throws IOException {
        this.frame = imageInputStream;
        this.debug = bl4;
        this.offset = this.frame.getStreamPosition();
        this.coefProbs = Globals.getDefaultCoefProbs();
        this.tokenBoolDecoders = new ArrayList<BoolDecoder>();
    }

    public void setProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        this.listener = iIOReadProgressListener;
    }

    private void createMacroBlocks() {
        this.macroBlocks = new MacroBlock[this.macroBlockRows + 2][this.macroBlockCols + 2];
        for (int i15 = 0; i15 < this.macroBlockRows + 2; ++i15) {
            for (int i16 = 0; i16 < this.macroBlockCols + 2; ++i16) {
                this.macroBlocks[i15][i16] = new MacroBlock(i16, i15, this.debug);
            }
        }
    }

    public boolean decode(WritableRaster writableRaster, ImageReadParam imageReadParam) throws IOException {
        int n15;
        int n16;
        int n17;
        int n18;
        this.segmentQuants = new SegmentQuants();
        int n19 = this.frame.readUnsignedByte();
        this.frameType = this.getBitAsInt(n19, 0);
        if (this.frameType != 0) {
            return false;
        }
        int n25 = this.getBitAsInt(n19, 1) << 1;
        n25 += this.getBitAsInt(n19, 2) << 1;
        n25 += this.getBitAsInt(n19, 3);
        int n26 = this.getBitAsInt(n19, 5);
        n26 += this.getBitAsInt(n19, 6) << 1;
        n26 += this.getBitAsInt(n19, 7) << 2;
        n19 = this.frame.readUnsignedByte();
        n26 += n19 << 3;
        n19 = this.frame.readUnsignedByte();
        n26 += n19 << 11;
        n19 = this.frame.readUnsignedByte();
        n19 = this.frame.readUnsignedByte();
        n19 = this.frame.readUnsignedByte();
        int n27 = n19 = this.frame.readUnsignedByte();
        n19 = this.frame.readUnsignedByte();
        this.width = (n27 += n19 << 8) & 0x3FFF;
        int n28 = n19 = this.frame.readUnsignedByte();
        n19 = this.frame.readUnsignedByte();
        this.height = (n28 += n19 << 8) & 0x3FFF;
        int n29 = this.width;
        int n35 = this.height;
        if ((n29 & 0xF) != 0) {
            n29 += 16 - (n29 & 0xF);
        }
        if ((n35 & 0xF) != 0) {
            n35 += 16 - (n35 & 0xF);
        }
        this.macroBlockRows = n35 >> 4;
        this.macroBlockCols = n29 >> 4;
        this.createMacroBlocks();
        this.offset = this.frame.getStreamPosition();
        BoolDecoder boolDecoder = new BoolDecoder(this.frame, this.offset);
        if (this.frameType == 0) {
            n18 = boolDecoder.readBit();
            n17 = boolDecoder.readBit();
        }
        this.segmentationIsEnabled = boolDecoder.readBit();
        if (this.segmentationIsEnabled > 0) {
            this.updateMacroBlockSegmentationMap = boolDecoder.readBit();
            this.updateMacroBlockSegmentatonData = boolDecoder.readBit();
            if (this.updateMacroBlockSegmentatonData > 0) {
                this.macroBlockSegementAbsoluteDelta = boolDecoder.readBit();
                for (n18 = 0; n18 < 4; ++n18) {
                    n17 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n17 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[0]);
                        if (boolDecoder.readBit() > 0) {
                            n17 = -n17;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n18].setQindex(n17);
                }
                for (n18 = 0; n18 < 4; ++n18) {
                    n17 = 0;
                    if (boolDecoder.readBit() > 0) {
                        n17 = boolDecoder.readLiteral(Globals.vp8MacroBlockFeatureDataBits[1]);
                        if (boolDecoder.readBit() > 0) {
                            n17 = -n17;
                        }
                    }
                    this.segmentQuants.getSegQuants()[n18].setFilterStrength(n17);
                }
                if (this.updateMacroBlockSegmentationMap > 0) {
                    this.macroBlockSegmentTreeProbs = new int[3];
                    for (n18 = 0; n18 < 3; ++n18) {
                        this.macroBlockSegmentTreeProbs[n18] = n17 = boolDecoder.readBit() > 0 ? boolDecoder.readLiteral(8) : 255;
                    }
                }
            }
        }
        this.simpleFilter = boolDecoder.readBit() != 0;
        this.filterLevel = boolDecoder.readLiteral(6);
        this.sharpnessLevel = boolDecoder.readLiteral(3);
        this.modeRefLoopFilterDeltaEnabled = boolDecoder.readBit();
        if (this.modeRefLoopFilterDeltaEnabled > 0) {
            this.modeRefLoopFilterDeltaUpdate = boolDecoder.readBit();
            if (this.modeRefLoopFilterDeltaUpdate > 0) {
                for (n18 = 0; n18 < 4; ++n18) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n18] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.refLoopFilterDeltas[n18] = this.refLoopFilterDeltas[n18] * -1;
                }
                for (n18 = 0; n18 < 4; ++n18) {
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n18] = boolDecoder.readLiteral(6);
                    if (boolDecoder.readBit() <= 0) continue;
                    this.modeLoopFilterDeltas[n18] = this.modeLoopFilterDeltas[n18] * -1;
                }
            }
        }
        this.setupTokenDecoder(boolDecoder, n26, this.offset);
        boolDecoder.seek();
        this.segmentQuants.parse(boolDecoder, this.segmentationIsEnabled == 1, this.macroBlockSegementAbsoluteDelta == 1);
        if (this.frameType != 0) {
            throw new IllegalArgumentException("Bad input: Not an Intra frame");
        }
        this.refreshEntropyProbs = boolDecoder.readBit();
        if (this.refreshEntropyProbs > 0) {
            // empty if block
        }
        this.refreshLastFrame = 0;
        this.refreshLastFrame = this.frameType == 0 ? 1 : boolDecoder.readBit();
        for (n18 = 0; n18 < 4; ++n18) {
            for (n17 = 0; n17 < 8; ++n17) {
                for (int i15 = 0; i15 < 3; ++i15) {
                    for (n16 = 0; n16 < 11; ++n16) {
                        if (boolDecoder.readBool(Globals.vp8CoefUpdateProbs[n18][n17][i15][n16]) <= 0) continue;
                        this.coefProbs[n18][n17][i15][n16] = n15 = boolDecoder.readLiteral(8);
                    }
                }
            }
        }
        this.macroBlockNoCoeffSkip = boolDecoder.readBit();
        if (this.frameType != 0) {
            throw new IIOException("Bad input: Not an Intra frame");
        }
        this.readModes(boolDecoder);
        n18 = 0;
        n17 = 1 << this.multiTokenPartition;
        Rectangle rectangle = imageReadParam != null && imageReadParam.getSourceRegion() != null ? imageReadParam.getSourceRegion() : writableRaster.getBounds();
        n16 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        n15 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        for (int i16 = 0; i16 < this.macroBlockRows; ++i16) {
            if (n17 > 1) {
                this.tokenBoolDecoder = this.tokenBoolDecoders.get(n18);
                this.tokenBoolDecoder.seek();
                if (++n18 == n17) {
                    n18 = 0;
                }
            }
            this.decodeMacroBlockRow(i16, writableRaster, rectangle, n16, n15);
            this.fireProgressUpdate(i16);
        }
        return true;
    }

    private void decodeMacroBlockRow(int n15, WritableRaster writableRaster, Rectangle rectangle, int n16, int n17) throws IOException {
        boolean bl4 = this.filterLevel != 0;
        MacroBlock macroBlock = null;
        MacroBlock[] macroBlockArray = this.macroBlocks[n15];
        MacroBlock[] macroBlockArray2 = this.macroBlocks[n15 + 1];
        for (int i15 = 0; i15 < this.macroBlockCols; ++i15) {
            MacroBlock macroBlock2 = macroBlockArray2[i15 + 1];
            macroBlock2.decodeMacroBlock(this);
            macroBlock2.dequantMacroBlock(this);
            if (bl4) {
                MacroBlock macroBlock3 = n15 > 0 ? macroBlockArray[i15 + 1] : null;
                LoopFilter.loopFilterBlock(macroBlock2, macroBlock, macroBlock3, this.frameType, this.simpleFilter, this.sharpnessLevel);
            }
            this.copyBlock(macroBlock2, writableRaster, rectangle, n16, n17);
            macroBlock = macroBlock2;
        }
    }

    private void fireProgressUpdate(int n15) {
        if (this.listener != null) {
            float f15 = 100.0f * ((float)(n15 + 1) / (float)this.getMacroBlockRows());
            this.listener.imageProgress(null, f15);
        }
    }

    public SubBlock getAboveRightSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        MacroBlock macroBlock = subBlock.getMacroBlock();
        int n15 = macroBlock.getSubblockX(subBlock);
        int n16 = macroBlock.getSubblockY(subBlock);
        if (plane == SubBlock.Plane.Y1) {
            if (n16 == 0 && n15 < 3) {
                MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
                SubBlock subBlock2 = macroBlock2.getSubBlock(plane, n15 + 1, 3);
                return subBlock2;
            }
            if (n16 == 0 && n15 == 3) {
                MacroBlock macroBlock3 = this.getMacroBlock(macroBlock.getX() + 1, macroBlock.getY() - 1);
                SubBlock subBlock3 = macroBlock3.getSubBlock(plane, 0, 3);
                if (macroBlock3.getX() == this.getMacroBlockCols()) {
                    int[][] nArray = new int[4][4];
                    for (int i15 = 0; i15 < 4; ++i15) {
                        for (int i16 = 0; i16 < 4; ++i16) {
                            nArray[i16][i15] = macroBlock3.getY() < 0 ? 127 : this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1).getSubBlock(SubBlock.Plane.Y1, 3, 3).getDest()[3][3];
                        }
                    }
                    subBlock3 = new SubBlock(macroBlock3, null, null, SubBlock.Plane.Y1);
                    subBlock3.setDest(nArray);
                }
                return subBlock3;
            }
            if (n16 > 0 && n15 < 3) {
                SubBlock subBlock4 = macroBlock.getSubBlock(plane, n15 + 1, n16 - 1);
                return subBlock4;
            }
            SubBlock subBlock5 = macroBlock.getSubBlock(subBlock.getPlane(), 3, 0);
            return this.getAboveRightSubBlock(subBlock5, plane);
        }
        throw new IllegalArgumentException("bad input: getAboveRightSubBlock()");
    }

    public SubBlock getAboveSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        SubBlock subBlock2 = subBlock.getAbove();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n15 = macroBlock.getSubblockX(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX(), macroBlock.getY() - 1);
            while (plane == SubBlock.Plane.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX(), macroBlock2.getY() - 1);
            }
            subBlock2 = macroBlock2.getBottomSubBlock(n15, subBlock.getPlane());
        }
        return subBlock2;
    }

    private int getBitAsInt(int n15, int n16) {
        int n17 = n15 & 1 << n16;
        if (n17 != 0) {
            return 1;
        }
        return 0;
    }

    int[][][][] getCoefProbs() {
        return this.coefProbs;
    }

    public BufferedImage getDebugImageDiff() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int[] nArray = new int[3];
                int n15 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.Y1, i15 % 16 / 4, i16 % 16 / 4).getDiff()[i15 % 4][i16 % 4];
                int n16 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.U, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDiff()[i15 / 2 % 4][i16 / 2 % 4];
                int n17 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.V, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDiff()[i15 / 2 % 4][i16 / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n15 - 16) + 1.596 * (double)(n17 - 128));
                nArray[1] = (int)(1.164 * (double)(n15 - 16) - 0.813 * (double)(n17 - 128) - 0.391 * (double)(n16 - 128));
                nArray[2] = (int)(1.164 * (double)(n15 - 16) + 2.018 * (double)(n16 - 128));
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImagePredict() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int[] nArray = new int[3];
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.Y1, i15 % 16 / 4, i16 % 16 / 4).getPredict()[i15 % 4][i16 % 4];
                int n16 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.U, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getPredict()[i15 / 2 % 4][i16 / 2 % 4];
                int n17 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.V, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getPredict()[i15 / 2 % 4][i16 / 2 % 4];
                nArray[0] = (int)(1.164 * (double)(n15 - 16) + 1.596 * (double)(n17 - 128));
                nArray[1] = (int)(1.164 * (double)(n15 - 16) - 0.813 * (double)(n17 - 128) - 0.391 * (double)(n16 - 128));
                nArray[2] = (int)(1.164 * (double)(n15 - 16) + 2.018 * (double)(n16 - 128));
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.U, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDest()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.U, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDiff()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageUPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.U, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getPredict()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.V, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDest()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.V, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getDiff()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageVPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.V, i15 / 2 % 8 / 4, i16 / 2 % 8 / 4).getPredict()[i15 / 2 % 4][i16 / 2 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.Y1, i15 % 16 / 4, i16 % 16 / 4).getDest()[i15 % 4][i16 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYDiffBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = 127 + this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.Y1, i15 % 16 / 4, i16 % 16 / 4).getDiff()[i15 % 4][i16 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public BufferedImage getDebugImageYPredBuffer() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        for (int i15 = 0; i15 < this.getWidth(); ++i15) {
            for (int i16 = 0; i16 < this.getHeight(); ++i16) {
                int n15 = this.getMacroBlock(i15 / 16, i16 / 16).getSubBlock(SubBlock.Plane.Y1, i15 % 16 / 4, i16 % 16 / 4).getPredict()[i15 % 4][i16 % 4];
                int[] nArray = new int[]{n15, n15, n15};
                for (int i17 = 0; i17 < 3; ++i17) {
                    if (nArray[i17] < 0) {
                        nArray[i17] = 0;
                    }
                    if (nArray[i17] <= 255) continue;
                    nArray[i17] = 255;
                }
                writableRaster.setPixel(i15, i16, nArray);
            }
        }
        return bufferedImage;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public SubBlock getLeftSubBlock(SubBlock subBlock, SubBlock.Plane plane) {
        SubBlock subBlock2 = subBlock.getLeft();
        if (subBlock2 == null) {
            MacroBlock macroBlock = subBlock.getMacroBlock();
            int n15 = macroBlock.getSubblockY(subBlock);
            MacroBlock macroBlock2 = this.getMacroBlock(macroBlock.getX() - 1, macroBlock.getY());
            while (plane == SubBlock.Plane.Y2 && macroBlock2.getYMode() == 4) {
                macroBlock2 = this.getMacroBlock(macroBlock2.getX() - 1, macroBlock2.getY());
            }
            subBlock2 = macroBlock2.getRightSubBlock(n15, subBlock.getPlane());
        }
        return subBlock2;
    }

    public MacroBlock getMacroBlock(int n15, int n16) {
        return this.macroBlocks[n16 + 1][n15 + 1];
    }

    public int getMacroBlockCols() {
        return this.macroBlockCols;
    }

    public String getMacroBlockDebugString(int n15, int n16, int n17, int n18) {
        String string = "";
        if (n15 < this.macroBlockCols && n16 < this.getMacroBlockRows()) {
            MacroBlock macroBlock = this.getMacroBlock(n15, n16);
            string = string + macroBlock.getDebugString();
            if (n17 < 4 && n18 < 4) {
                SubBlock subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y1, n17, n18);
                string = string + "\n SubBlock " + n17 + ", " + n18 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.Y2, n17, n18);
                string = string + "\n SubBlock " + n17 + ", " + n18 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.U, n17 / 2, n18 / 2);
                string = string + "\n SubBlock " + n17 / 2 + ", " + n18 / 2 + "\n  " + subBlock.getDebugString();
                subBlock = macroBlock.getSubBlock(SubBlock.Plane.V, n17 / 2, n18 / 2);
                string = string + "\n SubBlock " + n17 / 2 + ", " + n18 / 2 + "\n  " + subBlock.getDebugString();
            }
        }
        return string;
    }

    public int getMacroBlockRows() {
        return this.macroBlockRows;
    }

    public int getQIndex() {
        return this.segmentQuants.getqIndex();
    }

    public SegmentQuants getSegmentQuants() {
        return this.segmentQuants;
    }

    public int getSharpnessLevel() {
        return this.sharpnessLevel;
    }

    public BoolDecoder getTokenBoolDecoder() throws IOException {
        this.tokenBoolDecoder.seek();
        return this.tokenBoolDecoder;
    }

    private void readModes(BoolDecoder boolDecoder) throws IOException {
        int n15 = -1;
        int n16 = 0;
        if (this.macroBlockNoCoeffSkip > 0) {
            n16 = boolDecoder.readLiteral(8);
        }
        while (++n15 < this.macroBlockRows) {
            int n17 = -1;
            while (++n17 < this.macroBlockCols) {
                SubBlock subBlock;
                int n18;
                int n19;
                int n25;
                MacroBlock macroBlock = this.getMacroBlock(n17, n15);
                if (this.segmentationIsEnabled > 0 && this.updateMacroBlockSegmentationMap > 0) {
                    n25 = boolDecoder.readTree(Globals.macroBlockSegmentTree, this.macroBlockSegmentTreeProbs, 0);
                    macroBlock.setSegmentId(n25);
                }
                if (this.modeRefLoopFilterDeltaEnabled > 0) {
                    n25 = this.filterLevel;
                    n25 = (n25 += this.refLoopFilterDeltas[0]) < 0 ? 0 : Math.min(n25, 63);
                    macroBlock.setFilterLevel(n25);
                } else {
                    macroBlock.setFilterLevel(this.segmentQuants.getSegQuants()[macroBlock.getSegmentId()].getFilterStrength());
                }
                n25 = this.macroBlockNoCoeffSkip > 0 ? boolDecoder.readBool(n16) : 0;
                macroBlock.setSkipCoeff(n25);
                int n26 = this.readYMode(boolDecoder);
                macroBlock.setYMode(n26);
                if (n26 == 4) {
                    for (n19 = 0; n19 < 4; ++n19) {
                        for (n18 = 0; n18 < 4; ++n18) {
                            SubBlock subBlock2 = macroBlock.getYSubBlock(n18, n19);
                            subBlock = this.getAboveSubBlock(subBlock2, SubBlock.Plane.Y1);
                            SubBlock subBlock3 = this.getLeftSubBlock(subBlock2, SubBlock.Plane.Y1);
                            int n27 = this.readSubBlockMode(boolDecoder, subBlock.getMode(), subBlock3.getMode());
                            subBlock2.setMode(n27);
                        }
                    }
                    if (this.modeRefLoopFilterDeltaEnabled > 0) {
                        n19 = macroBlock.getFilterLevel();
                        n19 = (n19 += this.modeLoopFilterDeltas[0]) < 0 ? 0 : Math.min(n19, 63);
                        macroBlock.setFilterLevel(n19);
                    }
                } else {
                    switch (n26) {
                        case 1: {
                            n19 = 2;
                            break;
                        }
                        case 2: {
                            n19 = 3;
                            break;
                        }
                        case 3: {
                            n19 = 1;
                            break;
                        }
                        default: {
                            n19 = 0;
                        }
                    }
                    for (n18 = 0; n18 < 4; ++n18) {
                        for (int i15 = 0; i15 < 4; ++i15) {
                            subBlock = macroBlock.getYSubBlock(n18, i15);
                            subBlock.setMode(n19);
                        }
                    }
                }
                n19 = this.readUvMode(boolDecoder);
                macroBlock.setUvMode(n19);
            }
        }
    }

    private int readPartitionSize(long l15) throws IOException {
        this.frame.seek(l15);
        return this.frame.readUnsignedByte() + (this.frame.readUnsignedByte() << 8) + (this.frame.readUnsignedByte() << 16);
    }

    private int readSubBlockMode(BoolDecoder boolDecoder, int n15, int n16) throws IOException {
        return boolDecoder.readTree(Globals.vp8SubBlockModeTree, Globals.vp8KeyFrameSubBlockModeProb[n15][n16], 0);
    }

    private int readUvMode(BoolDecoder boolDecoder) throws IOException {
        return boolDecoder.readTree(Globals.vp8UVModeTree, Globals.vp8KeyFrameUVModeProb, 0);
    }

    private int readYMode(BoolDecoder boolDecoder) throws IOException {
        return boolDecoder.readTree(Globals.vp8KeyFrameYModeTree, Globals.vp8KeyFrameYModeProb, 0);
    }

    private void setupTokenDecoder(BoolDecoder boolDecoder, int n15, long l15) throws IOException {
        long l16;
        long l17 = l16 = l15 + (long)n15;
        this.multiTokenPartition = boolDecoder.readLiteral(2);
        int n16 = 1 << this.multiTokenPartition;
        if (n16 > 1) {
            l17 += 3L * (long)(n16 - 1);
        }
        for (int i15 = 0; i15 < n16; ++i15) {
            long l18;
            if (i15 < n16 - 1) {
                l18 = this.readPartitionSize(l16 + (long)i15 * 3L);
                boolDecoder.seek();
            } else {
                l18 = this.frame.length() - l17;
            }
            this.tokenBoolDecoders.add(new BoolDecoder(this.frame, l17));
            l17 += l18;
        }
        this.tokenBoolDecoder = this.tokenBoolDecoders.get(0);
    }

    private void copyBlock(MacroBlock macroBlock, WritableRaster writableRaster, Rectangle rectangle, int n15, int n16) {
        int n17 = macroBlock.getY() * 16 - rectangle.y;
        int n18 = Math.min(16, writableRaster.getHeight() * n16 - n17);
        int n19 = macroBlock.getX() * 16 - rectangle.x;
        int n25 = Math.min(16, writableRaster.getWidth() * n15 - n19);
        for (int i15 = 0; i15 < n18; i15 += n16) {
            int n26 = (n17 + i15) / n16;
            if (n26 < 0) continue;
            for (int i16 = 0; i16 < n25; i16 += n15) {
                int n27 = (n19 + i16) / n15;
                if (n27 < 0) continue;
                this.yuv[0] = (byte)macroBlock.getSubBlock(SubBlock.Plane.Y1, i16 / 4, i15 / 4).getDest()[i16 % 4][i15 % 4];
                this.yuv[1] = (byte)macroBlock.getSubBlock(SubBlock.Plane.U, i16 / 2 / 4, i15 / 2 / 4).getDest()[i16 / 2 % 4][i15 / 2 % 4];
                this.yuv[2] = (byte)macroBlock.getSubBlock(SubBlock.Plane.V, i16 / 2 / 4, i15 / 2 / 4).getDest()[i16 / 2 % 4][i15 / 2 % 4];
                YCbCrConverter.convertRec601YCbCr2RGB(this.yuv, this.rgb, 0);
                writableRaster.setDataElements(n27, n26, this.rgb);
            }
        }
    }
}

