/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Win32Lnk;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;

final class Win32File
extends File {
    private static final boolean IS_WINDOWS = Win32File.isWindows();

    private static boolean isWindows() {
        try {
            String string = System.getProperty("os.name");
            return string.toLowerCase().indexOf("windows") >= 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private Win32File(File file2) {
        super(file2.getPath());
    }

    public static void main(String[] stringArray) {
        int n15 = 0;
        boolean bl4 = false;
        while (stringArray.length > n15 + 1 && stringArray[n15].charAt(0) == '-' && stringArray[n15].length() > 1) {
            if (stringArray[n15].charAt(1) == 'R' || stringArray[n15].equals("--recursive")) {
                bl4 = true;
            } else {
                System.err.println("Unknown option: " + stringArray[n15]);
            }
            ++n15;
        }
        File file2 = Win32File.wrap(new File(stringArray[n15]));
        System.out.println("file: " + file2);
        System.out.println("file.getClass(): " + file2.getClass());
        Win32File.listFiles(file2, 0, bl4);
    }

    private static void listFiles(File file2, int n15, boolean bl4) {
        if (file2.isDirectory()) {
            File[] fileArray = file2.listFiles();
            for (int i15 = 0; i15 < n15; ++i15) {
                System.out.print(" ");
            }
            System.out.println("Contents of " + file2 + ": ");
            for (File file3 : fileArray) {
                for (int i16 = 0; i16 < n15; ++i16) {
                    System.out.print(" ");
                }
                System.out.println("  " + file3);
                if (!bl4) continue;
                Win32File.listFiles(file3, n15 + 1, n15 < 4);
            }
        }
    }

    public static File wrap(File file2) {
        if (file2 == null) {
            return null;
        }
        if (IS_WINDOWS) {
            if (file2 instanceof Win32File || file2 instanceof Win32Lnk) {
                return file2;
            }
            if (file2.exists() && file2.getName().endsWith(".lnk")) {
                try {
                    return new Win32Lnk(file2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new Win32File(file2);
        }
        return file2;
    }

    public static File[] wrap(File[] fileArray) {
        if (IS_WINDOWS) {
            for (int i15 = 0; fileArray != null && i15 < fileArray.length; ++i15) {
                fileArray[i15] = Win32File.wrap(fileArray[i15]);
            }
        }
        return fileArray;
    }

    @Override
    public File getAbsoluteFile() {
        return Win32File.wrap(super.getAbsoluteFile());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return Win32File.wrap(super.getCanonicalFile());
    }

    @Override
    public File getParentFile() {
        return Win32File.wrap(super.getParentFile());
    }

    @Override
    public File[] listFiles() {
        return Win32File.wrap(super.listFiles());
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        return Win32File.wrap(super.listFiles(fileFilter));
    }

    @Override
    public File[] listFiles(FilenameFilter filenameFilter) {
        return Win32File.wrap(super.listFiles(filenameFilter));
    }
}

