/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.jdk8.FlowableFromStream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlatMapStream<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;
    final int prefetch;

    public FlowableFlatMapStream(Flowable<T> source, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        if (this.source instanceof Supplier) {
            Stream<? extends R> stream = null;
            try {
                Object t15 = ((Supplier)((Object)this.source)).get();
                if (t15 != null) {
                    stream = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Stream");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptySubscription.error(ex4, s15);
                return;
            }
            if (stream != null) {
                FlowableFromStream.subscribeStream(s15, stream);
            } else {
                EmptySubscription.complete(s15);
            }
        } else {
            this.source.subscribe(FlowableFlatMapStream.subscribe(s15, this.mapper, this.prefetch));
        }
    }

    public static <T, R> Subscriber<T> subscribe(Subscriber<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        return new FlatMapStreamSubscriber<T, R>(downstream, mapper, prefetch);
    }

    static final class FlatMapStreamSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5127032662980523968L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        final int prefetch;
        final AtomicLong requested;
        SimpleQueue<T> queue;
        Subscription upstream;
        Iterator<? extends R> currentIterator;
        AutoCloseable currentCloseable;
        volatile boolean cancelled;
        volatile boolean upstreamDone;
        final AtomicThrowable error;
        long emitted;
        int consumed;
        int sourceMode;

        FlatMapStreamSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(@NonNull Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription qs4 = (QueueSubscription)s15;
                    int m15 = qs4.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.upstreamDone = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = qs4;
                        this.downstream.onSubscribe(this);
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s15.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.sourceMode != 2 && !this.queue.offer(t15)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.error.compareAndSet(null, t15)) {
                this.upstreamDone = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.drain();
        }

        void drain() {
            boolean canRequest;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> downstream = this.downstream;
            SimpleQueue<T> queue = this.queue;
            AtomicThrowable error = this.error;
            Iterator<Object> iterator2 = this.currentIterator;
            long requested = this.requested.get();
            long emitted = this.emitted;
            int limit = this.prefetch - (this.prefetch >> 2);
            boolean bl4 = canRequest = this.sourceMode != 1;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.clearCurrentSuppressCloseError();
                } else {
                    boolean isDone = this.upstreamDone;
                    if (error.get() != null) {
                        downstream.onError((Throwable)error.get());
                        this.cancelled = true;
                        continue;
                    }
                    if (iterator2 == null) {
                        boolean isEmpty;
                        T t15;
                        try {
                            t15 = queue.poll();
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.trySignalError(downstream, ex4);
                            continue;
                        }
                        boolean bl5 = isEmpty = t15 == null;
                        if (isDone && isEmpty) {
                            downstream.onComplete();
                            this.cancelled = true;
                        } else if (!isEmpty) {
                            if (canRequest && ++this.consumed == limit) {
                                this.consumed = 0;
                                this.upstream.request(limit);
                            }
                            try {
                                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null Stream");
                                iterator2 = stream.iterator();
                                if (iterator2.hasNext()) {
                                    this.currentIterator = iterator2;
                                    this.currentCloseable = stream;
                                    continue;
                                }
                                iterator2 = null;
                            }
                            catch (Throwable ex5) {
                                Exceptions.throwIfFatal(ex5);
                                this.trySignalError(downstream, ex5);
                            }
                            continue;
                        }
                    }
                    if (iterator2 != null && emitted != requested) {
                        R item;
                        try {
                            item = Objects.requireNonNull(iterator2.next(), "The Stream.Iterator returned a null value");
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.trySignalError(downstream, ex6);
                            continue;
                        }
                        if (this.cancelled) continue;
                        downstream.onNext(item);
                        ++emitted;
                        if (this.cancelled) continue;
                        try {
                            if (iterator2.hasNext()) continue;
                            iterator2 = null;
                            this.clearCurrentRethrowCloseError();
                        }
                        catch (Throwable ex7) {
                            Exceptions.throwIfFatal(ex7);
                            this.trySignalError(downstream, ex7);
                        }
                        continue;
                    }
                }
                this.emitted = emitted;
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                requested = this.requested.get();
            }
        }

        void clearCurrentRethrowCloseError() throws Throwable {
            this.currentIterator = null;
            AutoCloseable ac5 = this.currentCloseable;
            this.currentCloseable = null;
            if (ac5 != null) {
                ac5.close();
            }
        }

        void clearCurrentSuppressCloseError() {
            try {
                this.clearCurrentRethrowCloseError();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                RxJavaPlugins.onError(ex4);
            }
        }

        void trySignalError(Subscriber<?> downstream, Throwable ex4) {
            if (this.error.compareAndSet(null, ex4)) {
                this.upstream.cancel();
                this.cancelled = true;
                downstream.onError(ex4);
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }
    }
}

