/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.BackpressureOverflowStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBufferStrategy<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long bufferSize;
    final Action onOverflow;
    final BackpressureOverflowStrategy strategy;
    final Consumer<? super T> onDropped;

    public FlowableOnBackpressureBufferStrategy(Flowable<T> source, long bufferSize, Action onOverflow, BackpressureOverflowStrategy strategy, Consumer<? super T> onDropped) {
        super(source);
        this.bufferSize = bufferSize;
        this.onOverflow = onOverflow;
        this.strategy = strategy;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new OnBackpressureBufferStrategySubscriber<T>(s15, this.onOverflow, this.strategy, this.bufferSize, this.onDropped));
    }

    static final class OnBackpressureBufferStrategySubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 3240706908776709697L;
        final Subscriber<? super T> downstream;
        final Action onOverflow;
        final Consumer<? super T> onDropped;
        final BackpressureOverflowStrategy strategy;
        final long bufferSize;
        final AtomicLong requested;
        final Deque<T> deque;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        OnBackpressureBufferStrategySubscriber(Subscriber<? super T> actual, Action onOverflow, BackpressureOverflowStrategy strategy, long bufferSize, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.onOverflow = onOverflow;
            this.strategy = strategy;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.deque = new ArrayDeque<T>();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            boolean callOnOverflow = false;
            boolean callError = false;
            boolean callDrain = false;
            Deque<T> dq4 = this.deque;
            Object toDrop = null;
            Deque<T> deque = dq4;
            synchronized (deque) {
                if ((long)dq4.size() == this.bufferSize) {
                    switch (this.strategy) {
                        case DROP_LATEST: {
                            toDrop = dq4.pollLast();
                            dq4.offer(t15);
                            callOnOverflow = true;
                            break;
                        }
                        case DROP_OLDEST: {
                            toDrop = dq4.poll();
                            dq4.offer(t15);
                            callOnOverflow = true;
                            break;
                        }
                        default: {
                            toDrop = t15;
                            callError = true;
                            break;
                        }
                    }
                } else {
                    dq4.offer(t15);
                    callDrain = true;
                }
            }
            if (callOnOverflow && this.onOverflow != null) {
                try {
                    this.onOverflow.run();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.onError(ex4);
                }
            }
            if (this.onDropped != null && toDrop != null) {
                try {
                    this.onDropped.accept(toDrop);
                }
                catch (Throwable ex5) {
                    Exceptions.throwIfFatal(ex5);
                    this.upstream.cancel();
                    this.onError(ex5);
                }
            }
            if (callError) {
                this.upstream.cancel();
                this.onError(MissingBackpressureException.createDefault());
            }
            if (callDrain) {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.clear(this.deque);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(Deque<T> dq4) {
            Deque<T> deque = dq4;
            synchronized (deque) {
                dq4.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Deque<T> dq4 = this.deque;
            Subscriber<T> a15 = this.downstream;
            do {
                boolean d15;
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    boolean empty2;
                    T v15;
                    if (this.cancelled) {
                        this.clear(dq4);
                        return;
                    }
                    d15 = this.done;
                    Deque<T> deque = dq4;
                    synchronized (deque) {
                        v15 = dq4.poll();
                    }
                    boolean bl4 = empty2 = v15 == null;
                    if (d15) {
                        Throwable ex4 = this.error;
                        if (ex4 != null) {
                            this.clear(dq4);
                            a15.onError(ex4);
                            return;
                        }
                        if (empty2) {
                            a15.onComplete();
                            return;
                        }
                    }
                    if (empty2) break;
                    a15.onNext(v15);
                }
                if (e15 == r15) {
                    boolean empty;
                    if (this.cancelled) {
                        this.clear(dq4);
                        return;
                    }
                    d15 = this.done;
                    Deque<T> empty2 = dq4;
                    synchronized (empty2) {
                        empty = dq4.isEmpty();
                    }
                    if (d15) {
                        Throwable ex5 = this.error;
                        if (ex5 != null) {
                            this.clear(dq4);
                            a15.onError(ex5);
                            return;
                        }
                        if (empty) {
                            a15.onComplete();
                            return;
                        }
                    }
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

