/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeObserveOn<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Scheduler scheduler;

    public MaybeObserveOn(MaybeSource<T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new ObserveOnMaybeObserver<T>(observer, this.scheduler));
    }

    static final class ObserveOnMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 8571289934935992137L;
        final MaybeObserver<? super T> downstream;
        final Scheduler scheduler;
        T value;
        Throwable error;

        ObserveOnMaybeObserver(MaybeObserver<? super T> actual, Scheduler scheduler) {
            this.downstream = actual;
            this.scheduler = scheduler;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this, d15)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
        }

        @Override
        public void onError(Throwable e15) {
            this.error = e15;
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
        }

        @Override
        public void onComplete() {
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
        }

        @Override
        public void run() {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                this.error = null;
                this.downstream.onError(ex4);
            } else {
                T v15 = this.value;
                if (v15 != null) {
                    this.value = null;
                    this.downstream.onSuccess(v15);
                } else {
                    this.downstream.onComplete();
                }
            }
        }
    }
}

