/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractObservableWithUpstream<T, U> {
    final Supplier<U> bufferSupplier;
    final ObservableSource<? extends Open> bufferOpen;
    final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;

    public ObservableBufferBoundary(ObservableSource<T> source, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Supplier<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t15) {
        BufferBoundaryObserver parent = new BufferBoundaryObserver(t15, this.bufferOpen, this.bufferClose, this.bufferSupplier);
        t15.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class BufferCloseObserver<T, C extends Collection<? super T>>
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = -8498650778633225126L;
        final BufferBoundaryObserver<T, C, ?, ?> parent;
        final long index;

        BufferCloseObserver(BufferBoundaryObserver<T, C, ?, ?> parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(Object t15) {
            Disposable upstream = (Disposable)this.get();
            if (upstream != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                upstream.dispose();
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t15);
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (this.get() != DisposableHelper.DISPOSED) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.close(this, this.index);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class BufferBoundaryObserver<T, C extends Collection<? super T>, Open, Close>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8466418554264089604L;
        final Observer<? super C> downstream;
        final Supplier<C> bufferSupplier;
        final ObservableSource<? extends Open> bufferOpen;
        final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;
        final CompositeDisposable observers;
        final AtomicReference<Disposable> upstream;
        final AtomicThrowable errors;
        volatile boolean done;
        final SpscLinkedArrayQueue<C> queue;
        volatile boolean cancelled;
        long index;
        Map<Long, C> buffers;

        BufferBoundaryObserver(Observer<? super C> actual, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Supplier<C> bufferSupplier) {
            this.downstream = actual;
            this.bufferSupplier = bufferSupplier;
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.queue = new SpscLinkedArrayQueue(Observable.bufferSize());
            this.observers = new CompositeDisposable();
            this.upstream = new AtomicReference();
            this.buffers = new LinkedHashMap<Long, C>();
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this.upstream, d15)) {
                BufferOpenObserver open = new BufferOpenObserver(this);
                this.observers.add(open);
                this.bufferOpen.subscribe(open);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b15 : bufs.values()) {
                    b15.add(t15);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            this.observers.dispose();
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                for (Collection b15 : bufs.values()) {
                    this.queue.offer(b15);
                }
                this.buffers = null;
            }
            this.done = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this.upstream)) {
                this.cancelled = true;
                this.observers.dispose();
                BufferBoundaryObserver bufferBoundaryObserver = this;
                synchronized (bufferBoundaryObserver) {
                    this.buffers = null;
                }
                if (this.getAndIncrement() != 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open token) {
            ObservableSource<Close> p15;
            Collection buf;
            try {
                buf = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection");
                p15 = Objects.requireNonNull(this.bufferClose.apply(token), "The bufferClose returned a null ObservableSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                DisposableHelper.dispose(this.upstream);
                this.onError(ex4);
                return;
            }
            long idx = this.index;
            this.index = idx + 1L;
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                bufs.put(idx, buf);
            }
            BufferCloseObserver bc5 = new BufferCloseObserver(this, idx);
            this.observers.add(bc5);
            p15.subscribe(bc5);
        }

        void openComplete(BufferOpenObserver<Open> os4) {
            this.observers.delete(os4);
            if (this.observers.size() == 0) {
                DisposableHelper.dispose(this.upstream);
                this.done = true;
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BufferCloseObserver<T, C> closer, long idx) {
            this.observers.delete(closer);
            boolean makeDone = false;
            if (this.observers.size() == 0) {
                makeDone = true;
                DisposableHelper.dispose(this.upstream);
            }
            BufferBoundaryObserver bufferBoundaryObserver = this;
            synchronized (bufferBoundaryObserver) {
                Map<Long, C> bufs = this.buffers;
                if (bufs == null) {
                    return;
                }
                this.queue.offer(this.buffers.remove(idx));
            }
            if (makeDone) {
                this.done = true;
            }
            this.drain();
        }

        void boundaryError(Disposable observer, Throwable ex4) {
            DisposableHelper.dispose(this.upstream);
            this.observers.delete(observer);
            this.onError(ex4);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<C> a15 = this.downstream;
            SpscLinkedArrayQueue<C> q15 = this.queue;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    q15.clear();
                    return;
                }
                boolean d15 = this.done;
                if (d15 && this.errors.get() != null) {
                    q15.clear();
                    this.errors.tryTerminateConsumer(a15);
                    return;
                }
                Collection v15 = (Collection)q15.poll();
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    a15.onComplete();
                    return;
                }
                if (!empty) {
                    a15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class BufferOpenObserver<Open>
        extends AtomicReference<Disposable>
        implements Observer<Open>,
        Disposable {
            private static final long serialVersionUID = -8498650778633225126L;
            final BufferBoundaryObserver<?, ?, Open, ?> parent;

            BufferOpenObserver(BufferBoundaryObserver<?, ?, Open, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onNext(Open t15) {
                this.parent.open(t15);
            }

            @Override
            public void onError(Throwable t15) {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.boundaryError(this, t15);
            }

            @Override
            public void onComplete() {
                this.lazySet(DisposableHelper.DISPOSED);
                this.parent.openComplete(this);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return this.get() == DisposableHelper.DISPOSED;
            }
        }
    }
}

