/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleAmb<T>
extends Single<T> {
    private final SingleSource<? extends T>[] sources;
    private final Iterable<? extends SingleSource<? extends T>> sourcesIterable;

    public SingleAmb(SingleSource<? extends T>[] sources, Iterable<? extends SingleSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SingleSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new SingleSource[8];
            try {
                for (SingleSource<? extends T> singleSource : this.sourcesIterable) {
                    if (singleSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count == sources.length) {
                        SingleSource[] b15 = new SingleSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b15, 0, count);
                        sources = b15;
                    }
                    sources[count++] = singleSource;
                }
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                EmptyDisposable.error(e15, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        AtomicBoolean winner = new AtomicBoolean();
        CompositeDisposable compositeDisposable = new CompositeDisposable();
        observer.onSubscribe(compositeDisposable);
        for (int i15 = 0; i15 < count; ++i15) {
            SingleSource<T> s15 = sources[i15];
            if (compositeDisposable.isDisposed()) {
                return;
            }
            if (s15 == null) {
                compositeDisposable.dispose();
                NullPointerException e16 = new NullPointerException("One of the sources is null");
                if (winner.compareAndSet(false, true)) {
                    observer.onError(e16);
                } else {
                    RxJavaPlugins.onError(e16);
                }
                return;
            }
            s15.subscribe(new AmbSingleObserver<T>(observer, compositeDisposable, winner));
        }
    }

    static final class AmbSingleObserver<T>
    implements SingleObserver<T> {
        final CompositeDisposable set;
        final SingleObserver<? super T> downstream;
        final AtomicBoolean winner;
        Disposable upstream;

        AmbSingleObserver(SingleObserver<? super T> observer, CompositeDisposable set, AtomicBoolean winner) {
            this.downstream = observer;
            this.set = set;
            this.winner = winner;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.upstream = d15;
            this.set.add(d15);
        }

        @Override
        public void onSuccess(T value) {
            if (this.winner.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e15) {
            if (this.winner.compareAndSet(false, true)) {
                this.set.delete(this.upstream);
                this.set.dispose();
                this.downstream.onError(e15);
            } else {
                RxJavaPlugins.onError(e15);
            }
        }
    }
}

