/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subjects;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleSubject<T>
extends Single<T>
implements SingleObserver<T> {
    final AtomicReference<SingleDisposable<T>[]> observers;
    static final SingleDisposable[] EMPTY = new SingleDisposable[0];
    static final SingleDisposable[] TERMINATED = new SingleDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    T value;
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> SingleSubject<T> create() {
        return new SingleSubject<T>();
    }

    SingleSubject() {
        this.observers = new AtomicReference<SingleDisposable[]>(EMPTY);
    }

    @Override
    public void onSubscribe(@NonNull Disposable d15) {
        if (this.observers.get() == TERMINATED) {
            d15.dispose();
        }
    }

    @Override
    public void onSuccess(@NonNull T value) {
        ExceptionHelper.nullCheck(value, "onSuccess called with a null value.");
        if (this.once.compareAndSet(false, true)) {
            this.value = value;
            for (SingleDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onSuccess(value);
            }
        }
    }

    @Override
    public void onError(@NonNull Throwable e15) {
        ExceptionHelper.nullCheck(e15, "onError called with a null Throwable.");
        if (this.once.compareAndSet(false, true)) {
            this.error = e15;
            for (SingleDisposable md5 : this.observers.getAndSet(TERMINATED)) {
                md5.downstream.onError(e15);
            }
        } else {
            RxJavaPlugins.onError(e15);
        }
    }

    @Override
    protected void subscribeActual(@NonNull SingleObserver<? super T> observer) {
        SingleDisposable<T> md5 = new SingleDisposable<T>(observer, this);
        observer.onSubscribe(md5);
        if (this.add(md5)) {
            if (md5.isDisposed()) {
                this.remove(md5);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                observer.onError(ex4);
            } else {
                observer.onSuccess(this.value);
            }
        }
    }

    boolean add(@NonNull SingleDisposable<T> inner) {
        SingleDisposable[] b15;
        SingleDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new SingleDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = inner;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(@NonNull SingleDisposable<T> inner) {
        SingleDisposable[] b15;
        SingleDisposable<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != inner) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new SingleDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    @Nullable
    public T getValue() {
        if (this.observers.get() == TERMINATED) {
            return this.value;
        }
        return null;
    }

    public boolean hasValue() {
        return this.observers.get() == TERMINATED && this.value != null;
    }

    @Nullable
    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    static final class SingleDisposable<T>
    extends AtomicReference<SingleSubject<T>>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final SingleObserver<? super T> downstream;

        SingleDisposable(SingleObserver<? super T> actual, SingleSubject<T> parent) {
            this.downstream = actual;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            SingleSubject parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

