/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import jadx.api.JadxArgs;
import jadx.api.security.JadxSecurityFlag;
import jadx.api.security.impl.JadxSecurity;
import jadx.commons.app.JadxCommonEnv;
import jadx.zip.security.DisabledZipSecurity;
import jadx.zip.security.IJadxZipSecurity;
import jadx.zip.security.JadxZipSecurity;
import java.util.Set;

public class JadxAppCommon {
    public static void applyEnvVars(JadxArgs jadxArgs) {
        IJadxZipSecurity zipSecurity;
        boolean disableZipSecurity;
        Set<JadxSecurityFlag> flags = JadxSecurityFlag.all();
        boolean disableXmlSecurity = JadxCommonEnv.getBool("JADX_DISABLE_XML_SECURITY", false);
        if (disableXmlSecurity) {
            flags.remove((Object)JadxSecurityFlag.SECURE_XML_PARSER);
            flags.remove((Object)JadxSecurityFlag.VERIFY_APP_PACKAGE);
        }
        if (disableZipSecurity = JadxCommonEnv.getBool("JADX_DISABLE_ZIP_SECURITY", false)) {
            flags.remove((Object)JadxSecurityFlag.SECURE_ZIP_READER);
            zipSecurity = DisabledZipSecurity.INSTANCE;
        } else {
            int setZipBombDetectionFactor;
            int zipBombMinUncompressedSize;
            JadxZipSecurity jadxZipSecurity = new JadxZipSecurity();
            int maxZipEntriesCount = JadxCommonEnv.getInt("JADX_ZIP_MAX_ENTRIES_COUNT", -2);
            if (maxZipEntriesCount != -2) {
                jadxZipSecurity.setMaxEntriesCount(maxZipEntriesCount);
            }
            if ((zipBombMinUncompressedSize = JadxCommonEnv.getInt("JADX_ZIP_BOMB_MIN_UNCOMPRESSED_SIZE", -2)) != -2) {
                jadxZipSecurity.setZipBombMinUncompressedSize(zipBombMinUncompressedSize);
            }
            if ((setZipBombDetectionFactor = JadxCommonEnv.getInt("JADX_ZIP_BOMB_DETECTION_FACTOR", -2)) != -2) {
                jadxZipSecurity.setZipBombDetectionFactor(setZipBombDetectionFactor);
            }
            zipSecurity = jadxZipSecurity;
        }
        jadxArgs.setSecurity(new JadxSecurity(flags, zipSecurity));
    }
}

