/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.IDexTreeVisitor;

public class DepthTraversal {
    public static void visit(IDexTreeVisitor visitor2, ClassNode cls) {
        try {
            if (visitor2.visit(cls)) {
                cls.getInnerClasses().forEach(inCls -> DepthTraversal.visit(visitor2, inCls));
                cls.getMethods().forEach(mth -> DepthTraversal.visit(visitor2, mth));
            }
        }
        catch (BootstrapMethodError | Exception | StackOverflowError e15) {
            cls.addError(e15.getClass().getSimpleName() + " in pass: " + visitor2.getClass().getSimpleName(), e15);
        }
    }

    public static void visit(IDexTreeVisitor visitor2, MethodNode mth) {
        try {
            if (mth.contains(AType.JADX_ERROR)) {
                return;
            }
            visitor2.visit(mth);
        }
        catch (BootstrapMethodError | Exception | StackOverflowError e15) {
            mth.addError(e15.getClass().getSimpleName() + " in pass: " + visitor2.getClass().getSimpleName(), e15);
        }
    }

    private DepthTraversal() {
    }
}

