/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.cli.JadxCLIArgs;
import jadx.cli.config.JadxConfigAdapter;
import jadx.commons.app.JadxSystemInfo;
import jadx.core.Jadx;
import jadx.core.utils.files.FileUtils;
import jadx.gui.logs.LogCollector;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsData;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.NLS;
import java.awt.Desktop;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            JadxConfigAdapter<JadxSettingsData> configAdapter = JadxSettings.buildConfigAdapter();
            JadxSettingsData settingsData = JadxCLIArgs.processArgs(args, new JadxSettingsData(), configAdapter);
            if (settingsData == null) {
                return;
            }
            JadxSettings settings = new JadxSettings(configAdapter);
            settings.loadSettingsData(settingsData);
            LogCollector.register();
            JadxGUI.printSystemInfo();
            NLS.setLocale(settings.getLangLocale());
            SwingUtilities.invokeLater(() -> {
                LafManager.init(settings);
                settings.getFontSettings().updateDefaultFont();
                MainWindow mw4 = new MainWindow(settings);
                JadxGUI.registerOpenFileHandler(mw4);
                mw4.init();
            });
        }
        catch (Exception e15) {
            LOG.error("Error: {}", (Object)e15.getMessage(), (Object)e15);
            System.exit(1);
        }
    }

    private static void registerOpenFileHandler(MainWindow mw4) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_OPEN_FILE)) {
                desktop.setOpenFileHandler(e15 -> mw4.open(FileUtils.toPaths(e15.getFiles())));
            }
        }
        catch (Throwable e16) {
            LOG.error("Failed to register open file handler", e16);
        }
    }

    private static void printSystemInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting jadx-gui. Version: '{}'. JVM: {} {}. OS: {}, version: {}, arch: {}", Jadx.getVersion(), JadxSystemInfo.JAVA_VM, JadxSystemInfo.JAVA_VER, JadxSystemInfo.OS_NAME, JadxSystemInfo.OS_VERSION, JadxSystemInfo.OS_ARCH);
        }
    }
}

