/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import jadx.gui.logs.ILogListener;
import jadx.gui.logs.LogEvent;
import jadx.gui.ui.panel.IssuesPanel;
import jadx.gui.utils.rx.DebounceUpdate;
import javax.swing.SwingUtilities;

public class IssuesListener
implements ILogListener {
    private final IssuesPanel issuesPanel;
    private final DebounceUpdate updater;
    private int errors = 0;
    private int warnings = 0;

    public IssuesListener(IssuesPanel issuesPanel) {
        this.issuesPanel = issuesPanel;
        this.updater = new DebounceUpdate(500, this::onUpdate);
    }

    private void onUpdate() {
        SwingUtilities.invokeLater(() -> this.issuesPanel.onUpdate(this.errors, this.warnings));
    }

    @Override
    public void onAppend(LogEvent logEvent) {
        switch (logEvent.getLevel().toInt()) {
            case 40000: {
                ++this.errors;
                this.updater.requestUpdate();
                break;
            }
            case 30000: {
                ++this.warnings;
                this.updater.requestUpdate();
            }
        }
    }

    @Override
    public void onReload() {
        this.errors = 0;
        this.warnings = 0;
        this.updater.requestUpdate();
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }
}

