/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.plugins.utils.Utils;
import jadx.gui.ui.codearea.CodeArea;
import java.util.Set;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.modes.JavaTokenMaker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxTokenMaker
extends JavaTokenMaker {
    private static final Logger LOG = LoggerFactory.getLogger(JadxTokenMaker.class);
    private final CodeArea codeArea;
    private static final Set<String> CONTEXTUAL_KEYWORDS = Utils.constSet("exports", "module", "non-sealed", "open", "opens", "permits", "provides", "record", "requires", "sealed", "to", "transitive", "uses", "var", "with", "yield");

    public JadxTokenMaker(CodeArea codeArea) {
        this.codeArea = codeArea;
    }

    @Override
    public Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        if (this.codeArea.isDisposed()) {
            return new TokenImpl();
        }
        try {
            Token tokens = super.getTokenList(text, initialTokenType, startOffset);
            if (tokens != null && tokens.getType() != 0) {
                this.processTokens(tokens);
            }
            return tokens;
        }
        catch (Throwable e15) {
            LOG.error("Process tokens failed for text: {}", (Object)text, (Object)e15);
            return new TokenImpl();
        }
    }

    private void processTokens(Token tokens) {
        Token prev = null;
        for (Token current = tokens; current != null && current.getType() != 0; current = current.getNextToken()) {
            if (prev != null) {
                switch (current.getType()) {
                    case 6: {
                        JadxTokenMaker.fixContextualKeyword(current);
                        break;
                    }
                    case 20: {
                        current = this.mergeLongClassNames(prev, current, false);
                        break;
                    }
                    case 19: {
                        current = this.mergeLongClassNames(prev, current, true);
                    }
                }
            }
            prev = current;
        }
    }

    private static void fixContextualKeyword(Token token) {
        String lexeme = token.getLexeme();
        if (lexeme != null && CONTEXTUAL_KEYWORDS.contains(lexeme)) {
            token.setType(20);
        }
    }

    @NotNull
    private Token mergeLongClassNames(Token prev, Token current, boolean annotation) {
        JavaClass javaCls;
        int offset = current.getTextOffset();
        if (annotation) {
            ++offset;
        }
        if ((javaCls = this.codeArea.getJavaClassIfAtPos(offset)) != null) {
            Token replace;
            String name = javaCls.getName();
            String lexeme = current.getLexeme();
            if (annotation && lexeme.length() > 1) {
                lexeme = lexeme.substring(1);
            }
            if (!lexeme.equals(name) && this.isClassNameStart(javaCls, lexeme) && (replace = this.concatTokensUntil(current, name)) != null && prev instanceof TokenImpl) {
                TokenImpl impl = (TokenImpl)prev;
                impl.setNextToken(replace);
                current = replace;
            }
        }
        return current;
    }

    private boolean isClassNameStart(JavaNode javaNode, String lexeme) {
        if (javaNode.getFullName().startsWith(lexeme)) {
            return true;
        }
        return javaNode.getTopParentClass().getName().startsWith(lexeme);
    }

    @Nullable
    private Token concatTokensUntil(Token start, String endText) {
        StringBuilder sb5 = new StringBuilder();
        for (Token current = start; current != null && current.getType() != 0; current = current.getNextToken()) {
            String text = current.getLexeme();
            if (text == null) continue;
            sb5.append(text);
            if (!text.equals(endText)) continue;
            char[] line = sb5.toString().toCharArray();
            TokenImpl token = new TokenImpl(line, 0, line.length - 1, start.getOffset(), start.getType(), start.getLanguageIndex());
            token.setNextToken(current.getNextToken());
            return token;
        }
        return null;
    }
}

