/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.gui.device.debugger.BreakpointManager;
import jadx.gui.device.debugger.DbgUtils;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.LoadTask;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.FoldingAwareIconRowHeader;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmaliArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliArea.class);
    private static final long serialVersionUID = 1334485631870306494L;
    private static final Icon ICON_BREAKPOINT = UiUtils.openSvgIcon("debugger/db_set_breakpoint");
    private static final Icon ICON_BREAKPOINT_DISABLED = UiUtils.openSvgIcon("debugger/db_disabled_breakpoint");
    private static final Color BREAKPOINT_LINE_COLOR = Color.decode("#ad103c");
    private static final Color DEBUG_LINE_COLOR = Color.decode("#9c1138");
    private final JNode textNode;
    private final JCheckBoxMenuItem cbUseSmaliV2;
    private boolean curVersion = false;
    private SmaliModel model;

    SmaliArea(final ContentPanel contentPanel, JClass node) {
        super(contentPanel, node);
        this.textNode = new TextNode(node.getName());
        this.setCodeFoldingEnabled(true);
        this.cbUseSmaliV2 = new JCheckBoxMenuItem(NLS.str("popup.bytecode_col"), this.shouldUseSmaliPrinterV2());
        this.cbUseSmaliV2.setAction(new AbstractAction(NLS.str("popup.bytecode_col")){
            private static final long serialVersionUID = -1111111202103170737L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                JadxSettings settings;
                settings.setSmaliAreaShowBytecode(!(settings = SmaliArea.this.getContentPanel().getMainWindow().getSettings()).isSmaliAreaShowBytecode());
                contentPanel.getTabbedPane().getTabs().forEach(v15 -> {
                    if (v15 instanceof ClassCodeContentPanel) {
                        SmaliArea.this.switchModel();
                        ((ClassCodeContentPanel)v15).getSmaliCodeArea().refresh();
                    }
                });
                settings.sync();
            }
        });
        this.getPopupMenu().add(this.cbUseSmaliV2);
        this.switchModel();
    }

    @Override
    public IBackgroundTask getLoadTask() {
        return new LoadTask<String>(() -> this.model.loadCode(), code -> {
            this.curVersion = this.shouldUseSmaliPrinterV2();
            this.model.loadUI((String)code);
            this.setCaretPosition(0);
            this.setLoaded();
        });
    }

    @Override
    public ICodeInfo getCodeInfo() {
        return ICodeInfo.EMPTY;
    }

    @Override
    public void refresh() {
        this.load();
    }

    @Override
    public JNode getNode() {
        return this.textNode;
    }

    @Override
    public JClass getJClass() {
        return (JClass)this.node;
    }

    private void switchModel() {
        if (this.model != null) {
            this.model.unload();
        }
        this.curVersion = this.shouldUseSmaliPrinterV2();
        this.model = this.curVersion ? new DebugModel() : new NormalModel(this);
        this.setUnLoaded();
        this.load();
    }

    public void scrollToDebugPos(int pos) {
        this.getContentPanel().getMainWindow().getSettings().setSmaliAreaShowBytecode(true);
        this.cbUseSmaliV2.setState(this.shouldUseSmaliPrinterV2());
        if (!(this.model instanceof DebugModel)) {
            this.switchModel();
            this.refresh();
        }
        this.model.togglePosHighlight(pos);
    }

    @Override
    public Font getFont() {
        if (this.model == null || this.isDisposed()) {
            return super.getFont();
        }
        return this.model.getFont();
    }

    @Override
    public Font getFontForTokenType(int type) {
        return this.getFont();
    }

    private boolean shouldUseSmaliPrinterV2() {
        return this.getContentPanel().getMainWindow().getSettings().isSmaliAreaShowBytecode();
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this){

            @Override
            public EditorKit getEditorKit(JTextComponent tc5) {
                return new RSyntaxTextAreaEditorKit(){
                    private static final long serialVersionUID = -1111111202103170740L;

                    @Override
                    public IconRowHeader createIconRowHeader(RTextArea textArea) {
                        return new FoldingAwareIconRowHeader((RSyntaxTextArea)textArea){
                            private static final long serialVersionUID = -1111111202103170739L;

                            @Override
                            public void mousePressed(MouseEvent e15) {
                                int offs = this.textArea.viewToModel2D(e15.getPoint());
                                if (offs > -1) {
                                    SmaliArea.this.model.setBreakpoint(offs);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private abstract class SmaliModel {
        private SmaliModel() {
        }

        abstract String loadCode();

        abstract void loadUI(String var1);

        abstract void unload();

        Font getFont() {
            return SmaliArea.super.getFont();
        }

        Font getFontForTokenType(int type) {
            return SmaliArea.super.getFontForTokenType(type);
        }

        void setBreakpoint(int off) {
        }

        void togglePosHighlight(int pos) {
        }
    }

    private class DebugModel
    extends SmaliModel {
        private KeyStroke bpShortcut;
        private Gutter gutter;
        private Object runningHighlightTag = null;
        private final SmaliV2Style smaliV2Style = new SmaliV2Style(SmaliArea.this);
        private final Map<Integer, BreakpointLine> bpMap = new HashMap<Integer, BreakpointLine>();
        private final PropertyChangeListener schemeListener = evt -> {
            if (this.smaliV2Style.refreshTheme()) {
                SmaliArea.this.setSyntaxScheme(this.smaliV2Style);
            }
        };

        public DebugModel() {
            this.loadV2Style();
            SmaliArea.this.setSyntaxEditingStyle("text/asm6502");
            SmaliArea.this.addPropertyChangeListener("RSTA.syntaxScheme", this.schemeListener);
            this.regBreakpointEvents();
        }

        @Override
        String loadCode() {
            return DbgUtils.getSmaliCode(((JClass)SmaliArea.this.node).getCls().getClassNode());
        }

        @Override
        void loadUI(String code) {
            if (this.gutter == null) {
                this.gutter = RSyntaxUtilities.getGutter(SmaliArea.this);
                this.gutter.setBookmarkingEnabled(true);
                this.gutter.setIconRowHeaderInheritsGutterBackground(true);
                Font baseFont = SmaliArea.super.getFont();
                this.gutter.setLineNumberFont(baseFont.deriveFont(baseFont.getSize2D() - 1.0f));
            }
            SmaliArea.this.setText(code);
            this.loadV2Style();
            this.loadBreakpoints();
        }

        @Override
        public void unload() {
            SmaliArea.this.removePropertyChangeListener(this.schemeListener);
            SmaliArea.this.removeLineHighlight(this.runningHighlightTag);
            UiUtils.removeKeyBinding(SmaliArea.this, this.bpShortcut, "set a break point");
            BreakpointManager.removeListener((JClass)SmaliArea.this.node);
            this.bpMap.forEach((k15, v15) -> v15.remove());
        }

        @Override
        public Font getFont() {
            return this.smaliV2Style.getFont();
        }

        @Override
        public Font getFontForTokenType(int type) {
            return this.smaliV2Style.getFont();
        }

        private void loadV2Style() {
            SmaliArea.this.setSyntaxScheme(this.smaliV2Style);
        }

        private void regBreakpointEvents() {
            this.bpShortcut = KeyStroke.getKeyStroke(113, 0);
            UiUtils.addKeyBinding((JComponent)SmaliArea.this, this.bpShortcut, "set break point", new AbstractAction(){
                private static final long serialVersionUID = -1111111202103170738L;

                @Override
                public void actionPerformed(ActionEvent e15) {
                    DebugModel.this.setBreakpoint(SmaliArea.this.getCaretPosition());
                }
            });
            BreakpointManager.addListener((JClass)SmaliArea.this.node, this::setBreakpointDisabled);
        }

        private void loadBreakpoints() {
            List<Integer> posList = BreakpointManager.getPositions((JClass)SmaliArea.this.node);
            for (Integer integer : posList) {
                this.setBreakpoint(integer);
            }
        }

        @Override
        public void setBreakpoint(int pos) {
            int line;
            try {
                line = SmaliArea.this.getLineOfOffset(pos);
            }
            catch (BadLocationException e15) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e15);
                return;
            }
            BreakpointLine bpLine = this.bpMap.remove(line);
            if (bpLine == null) {
                bpLine = new BreakpointLine(line);
                bpLine.setDisabled(false);
                this.bpMap.put(line, bpLine);
                if (!BreakpointManager.set((JClass)SmaliArea.this.node, line)) {
                    bpLine.setDisabled(true);
                }
            } else {
                BreakpointManager.remove((JClass)SmaliArea.this.node, line);
                bpLine.remove();
            }
        }

        @Override
        public void togglePosHighlight(int pos) {
            if (this.runningHighlightTag != null) {
                SmaliArea.this.removeLineHighlight(this.runningHighlightTag);
            }
            try {
                int line = SmaliArea.this.getLineOfOffset(pos);
                this.runningHighlightTag = SmaliArea.this.addLineHighlight(line, DEBUG_LINE_COLOR);
            }
            catch (BadLocationException e15) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e15);
            }
        }

        private void setBreakpointDisabled(int pos) {
            try {
                int line = SmaliArea.this.getLineOfOffset(pos);
                this.bpMap.computeIfAbsent(line, k15 -> new BreakpointLine(line)).setDisabled(true);
            }
            catch (BadLocationException e15) {
                LOG.error("Failed to get line by offset: {}", (Object)pos, (Object)e15);
            }
        }

        private void safeRemoveTrackingIcon(GutterIconInfo iconInfo) {
            if (this.gutter != null && iconInfo != null) {
                this.gutter.removeTrackingIcon(iconInfo);
            }
        }

        private class SmaliV2Style
        extends SyntaxScheme {
            public SmaliV2Style(SmaliArea smaliArea) {
                super(true);
                smaliArea.getContentPanel().getMainWindow().getEditorThemeManager().apply(smaliArea);
                this.updateTheme();
            }

            public Font getFont() {
                return SmaliArea.this.getContentPanel().getMainWindow().getSettings().getSmaliFont();
            }

            public boolean refreshTheme() {
                boolean refresh;
                boolean bl4 = refresh = SmaliArea.this.getSyntaxScheme() != this;
                if (refresh) {
                    this.updateTheme();
                }
                return refresh;
            }

            private void updateTheme() {
                Style[] mainStyles = SmaliArea.this.getSyntaxScheme().getStyles();
                Style[] styles = new Style[mainStyles.length];
                for (int i15 = 0; i15 < mainStyles.length; ++i15) {
                    Style mainStyle = mainStyles[i15];
                    styles[i15] = mainStyle == null ? new Style() : new Style(mainStyle.foreground, mainStyle.background, null);
                }
                this.setStyles(styles);
            }

            @Override
            public void restoreDefaults(Font baseFont) {
                this.restoreDefaults(baseFont, true);
            }

            @Override
            public void restoreDefaults(Font baseFont, boolean fontStyles) {
            }
        }

        private class BreakpointLine {
            Object highlightTag;
            GutterIconInfo iconInfo;
            boolean disabled;
            final int line;

            BreakpointLine(int line) {
                this.line = line;
                this.disabled = true;
            }

            void remove() {
                DebugModel.this.safeRemoveTrackingIcon(this.iconInfo);
                if (!this.disabled) {
                    SmaliArea.this.removeLineHighlight(this.highlightTag);
                }
            }

            void setDisabled(boolean disabled) {
                if (disabled) {
                    if (!this.disabled) {
                        DebugModel.this.safeRemoveTrackingIcon(this.iconInfo);
                        SmaliArea.this.removeLineHighlight(this.highlightTag);
                        try {
                            this.iconInfo = DebugModel.this.gutter.addLineTrackingIcon(this.line, ICON_BREAKPOINT_DISABLED);
                        }
                        catch (BadLocationException e15) {
                            LOG.error("Failed to add line tracking icon", e15);
                        }
                    }
                } else if (this.disabled) {
                    DebugModel.this.safeRemoveTrackingIcon(this.iconInfo);
                    try {
                        this.iconInfo = DebugModel.this.gutter.addLineTrackingIcon(this.line, ICON_BREAKPOINT);
                        this.highlightTag = SmaliArea.this.addLineHighlight(this.line, BREAKPOINT_LINE_COLOR);
                    }
                    catch (BadLocationException e16) {
                        LOG.error("Failed to remove line tracking icon", e16);
                    }
                }
                this.disabled = disabled;
            }
        }
    }

    private class NormalModel
    extends SmaliModel {
        public NormalModel(SmaliArea smaliArea2) {
            SmaliArea.this.getContentPanel().getMainWindow().getEditorThemeManager().apply(smaliArea2);
            SmaliArea.this.setSyntaxEditingStyle("text/smali");
        }

        @Override
        public String loadCode() {
            return SmaliArea.this.getJClass().getSmali();
        }

        @Override
        public void loadUI(String code) {
            SmaliArea.this.setText(code);
        }

        @Override
        public void unload() {
        }
    }
}

