/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.gui.ui.MainWindow;
import jadx.gui.utils.UiUtils;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(CommonDialog.class);
    protected final MainWindow mainWindow;

    public CommonDialog(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
    }

    protected void commonWindowInit() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        UiUtils.addEscapeShortCutToDispose(this);
        this.setLocationRelativeTo(null);
        UiUtils.uiRunAndWait(this::pack);
        Dimension minSize = this.getSize();
        this.setMinimumSize(minSize);
        if (!this.mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(CommonDialog.incByPercent(minSize.getWidth(), 30), CommonDialog.incByPercent(minSize.getHeight(), 30));
        }
    }

    @Override
    public void dispose() {
        try {
            this.mainWindow.getSettings().saveWindowPos(this);
        }
        catch (Exception e15) {
            LOG.warn("Failed to save window size and position", e15);
        }
        super.dispose();
    }

    private static int incByPercent(double value, int percent) {
        return (int)(value * (1.0 + (double)percent * 0.01));
    }
}

