/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.hexviewer.search.service;

import jadx.gui.ui.hexviewer.search.SearchCondition;
import jadx.gui.ui.hexviewer.search.SearchParameters;
import jadx.gui.ui.hexviewer.search.service.BinarySearchService;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.highlight.swing.SearchCodeAreaColorAssessor;
import org.exbin.bined.highlight.swing.SearchMatch;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.capability.ColorAssessorPainterCapable;
import org.exbin.bined.swing.section.SectCodeArea;

public class BinarySearchServiceImpl
implements BinarySearchService {
    private static final int MAX_MATCHES_COUNT = 100;
    private final SectCodeArea codeArea;
    private final SearchParameters lastSearchParameters = new SearchParameters();

    public BinarySearchServiceImpl(SectCodeArea codeArea) {
        this.codeArea = codeArea;
    }

    @Override
    public void performFind(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        long position;
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        SearchCondition condition2 = searchParameters.getCondition();
        searchStatusListener.clearStatus();
        if (condition2.isEmpty()) {
            searchAssessor.clearMatches();
            this.codeArea.repaint();
            return;
        }
        switch (searchParameters.getSearchDirection()) {
            case FORWARD: {
                if (searchParameters.isSearchFromCursor()) {
                    position = this.codeArea.getActiveCaretPosition().getDataPosition();
                    break;
                }
                position = 0L;
                break;
            }
            case BACKWARD: {
                long searchDataSize;
                if (searchParameters.isSearchFromCursor()) {
                    position = this.codeArea.getActiveCaretPosition().getDataPosition() - 1L;
                    break;
                }
                switch (condition2.getSearchMode()) {
                    case TEXT: {
                        searchDataSize = condition2.getSearchText().length();
                        break;
                    }
                    case BINARY: {
                        searchDataSize = condition2.getBinaryData().getDataSize();
                        break;
                    }
                    default: {
                        throw CodeAreaUtils.getInvalidTypeException(condition2.getSearchMode());
                    }
                }
                position = this.codeArea.getDataSize() - searchDataSize;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(searchParameters.getSearchDirection());
            }
        }
        searchParameters.setStartPosition(position);
        switch (condition2.getSearchMode()) {
            case TEXT: {
                this.searchForText(searchParameters, searchStatusListener);
                break;
            }
            case BINARY: {
                this.searchForBinaryData(searchParameters, searchStatusListener);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException(condition2.getSearchMode());
            }
        }
    }

    private void searchForBinaryData(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        SearchCondition condition2 = searchParameters.getCondition();
        BinaryData searchData = condition2.getBinaryData();
        long searchDataSize = searchData.getDataSize();
        BinaryData data = this.codeArea.getContentData();
        ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
        long dataSize = data.getDataSize();
        for (long position = searchParameters.getStartPosition(); position >= 0L && position <= dataSize - searchDataSize; ++position) {
            long matchLength;
            for (matchLength = 0L; matchLength < searchDataSize && data.getByte(position + matchLength) == searchData.getByte(matchLength); ++matchLength) {
            }
            if (matchLength != searchDataSize) continue;
            SearchMatch match = new SearchMatch();
            match.setPosition(position);
            match.setLength(searchDataSize);
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                foundMatches.add(0, match);
            } else {
                foundMatches.add(match);
            }
            if (foundMatches.size() == 100 || searchParameters.getMatchMode() == SearchParameters.MatchMode.SINGLE) break;
        }
        searchAssessor.setMatches(foundMatches);
        if (!foundMatches.isEmpty()) {
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                searchAssessor.setCurrentMatchIndex(foundMatches.size() - 1);
            } else {
                searchAssessor.setCurrentMatchIndex(0);
            }
            SearchMatch firstMatch = Objects.requireNonNull(searchAssessor.getCurrentMatch());
            this.codeArea.revealPosition(firstMatch.getPosition(), 0, this.codeArea.getActiveSection());
        }
        this.lastSearchParameters.setFromParameters(searchParameters);
        searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), foundMatches.isEmpty() ? -1 : searchAssessor.getCurrentMatchIndex()), searchParameters.getMatchMode());
        this.codeArea.repaint();
    }

    private void searchForText(SearchParameters searchParameters, BinarySearchService.SearchStatusListener searchStatusListener) {
        int maxBytesPerChar;
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        SearchCondition condition2 = searchParameters.getCondition();
        long position = searchParameters.getStartPosition();
        String findText = searchParameters.isMatchCase() ? condition2.getSearchText() : condition2.getSearchText().toLowerCase();
        long searchDataSize = findText.length();
        BinaryData data = this.codeArea.getContentData();
        ArrayList<SearchMatch> foundMatches = new ArrayList<SearchMatch>();
        Charset charset = this.codeArea.getCharset();
        try {
            CharsetEncoder encoder = charset.newEncoder();
            maxBytesPerChar = (int)encoder.maxBytesPerChar();
        }
        catch (UnsupportedOperationException ex4) {
            maxBytesPerChar = 8;
        }
        byte[] charData = new byte[maxBytesPerChar];
        long dataSize = data.getDataSize();
        long lastPosition = position;
        block6: while (position >= 0L && position <= dataSize - searchDataSize) {
            int matchCharLength = 0;
            int matchLength = 0;
            while (matchCharLength < (int)searchDataSize) {
                if (Thread.interrupted()) {
                    return;
                }
                long searchPosition = position + (long)matchLength;
                int bytesToUse = maxBytesPerChar;
                if (searchPosition + (long)bytesToUse > dataSize) {
                    bytesToUse = (int)(dataSize - searchPosition);
                }
                if (searchPosition == lastPosition + 1L) {
                    System.arraycopy(charData, 1, charData, 0, maxBytesPerChar - 1);
                    charData[bytesToUse - 1] = data.getByte(searchPosition + (long)bytesToUse - 1L);
                } else if (searchPosition == lastPosition - 1L) {
                    System.arraycopy(charData, 0, charData, 1, maxBytesPerChar - 1);
                    charData[0] = data.getByte(searchPosition);
                } else {
                    data.copyToArray(searchPosition, charData, 0, bytesToUse);
                }
                if (bytesToUse < maxBytesPerChar) {
                    Arrays.fill(charData, bytesToUse, maxBytesPerChar, (byte)0);
                }
                lastPosition = searchPosition;
                char singleChar = new String(charData, charset).charAt(0);
                if (searchParameters.isMatchCase() ? singleChar != findText.charAt(matchCharLength) : Character.toLowerCase(singleChar) != findText.charAt(matchCharLength)) break;
                int characterLength = String.valueOf(singleChar).getBytes(charset).length;
                ++matchCharLength;
                matchLength += characterLength;
            }
            if (matchCharLength == findText.length()) {
                SearchMatch match = new SearchMatch();
                match.setPosition(position);
                match.setLength(matchLength);
                if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                    foundMatches.add(0, match);
                } else {
                    foundMatches.add(match);
                }
                if (foundMatches.size() == 100 || searchParameters.getMatchMode() == SearchParameters.MatchMode.SINGLE) break;
            }
            switch (searchParameters.getSearchDirection()) {
                case FORWARD: {
                    ++position;
                    continue block6;
                }
                case BACKWARD: {
                    --position;
                    continue block6;
                }
            }
            throw CodeAreaUtils.getInvalidTypeException(searchParameters.getSearchDirection());
        }
        if (Thread.interrupted()) {
            return;
        }
        searchAssessor.setMatches(foundMatches);
        if (!foundMatches.isEmpty()) {
            if (searchParameters.getSearchDirection() == SearchParameters.SearchDirection.BACKWARD) {
                searchAssessor.setCurrentMatchIndex(foundMatches.size() - 1);
            } else {
                searchAssessor.setCurrentMatchIndex(0);
            }
            SearchMatch firstMatch = searchAssessor.getCurrentMatch();
            this.codeArea.revealPosition(firstMatch.getPosition(), 0, this.codeArea.getActiveSection());
        }
        this.lastSearchParameters.setFromParameters(searchParameters);
        searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), foundMatches.isEmpty() ? -1 : searchAssessor.getCurrentMatchIndex()), searchParameters.getMatchMode());
        this.codeArea.repaint();
    }

    @Override
    public void setMatchPosition(int matchPosition) {
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        searchAssessor.setCurrentMatchIndex(matchPosition);
        SearchMatch currentMatch = searchAssessor.getCurrentMatch();
        this.codeArea.revealPosition(currentMatch.getPosition(), 0, this.codeArea.getActiveSection());
        this.codeArea.repaint();
    }

    @Override
    public void performFindAgain(BinarySearchService.SearchStatusListener searchStatusListener) {
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        List<SearchMatch> foundMatches = searchAssessor.getMatches();
        int matchesCount = foundMatches.size();
        if (matchesCount > 0) {
            block0 : switch (this.lastSearchParameters.getMatchMode()) {
                case MULTIPLE: {
                    if (matchesCount <= 1) break;
                    int currentMatchIndex = searchAssessor.getCurrentMatchIndex();
                    this.setMatchPosition(currentMatchIndex < matchesCount - 1 ? currentMatchIndex + 1 : 0);
                    searchStatusListener.setStatus(new BinarySearchService.FoundMatches(foundMatches.size(), searchAssessor.getCurrentMatchIndex()), this.lastSearchParameters.getMatchMode());
                    break;
                }
                case SINGLE: {
                    switch (this.lastSearchParameters.getSearchDirection()) {
                        case FORWARD: {
                            this.lastSearchParameters.setStartPosition(foundMatches.get(0).getPosition() + 1L);
                            break;
                        }
                        case BACKWARD: {
                            SearchMatch match = foundMatches.get(0);
                            this.lastSearchParameters.setStartPosition(match.getPosition() - 1L);
                        }
                    }
                    SearchCondition condition2 = this.lastSearchParameters.getCondition();
                    switch (condition2.getSearchMode()) {
                        case TEXT: {
                            this.searchForText(this.lastSearchParameters, searchStatusListener);
                            break block0;
                        }
                        case BINARY: {
                            this.searchForBinaryData(this.lastSearchParameters, searchStatusListener);
                            break block0;
                        }
                    }
                    throw CodeAreaUtils.getInvalidTypeException(condition2.getSearchMode());
                }
            }
        }
    }

    @Override
    public SearchParameters getLastSearchParameters() {
        return this.lastSearchParameters;
    }

    @Override
    public void clearMatches() {
        SearchCodeAreaColorAssessor searchAssessor = CodeAreaSwingUtils.findColorAssessor((ColorAssessorPainterCapable)((Object)this.codeArea.getPainter()), SearchCodeAreaColorAssessor.class);
        searchAssessor.clearMatches();
    }
}

